/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.internal.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.command.ArgumentTypeMod;
import net.darkhax.bookshelf.internal.command.CommandHand;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.CommandUtils;
import net.darkhax.bookshelf.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class BookshelfCommands {
    private static final String LOOT_TABLE_BLOCK_DROP_SELF = "{\"type\":\"minecraft:block\",\"pools\":[{\"rolls\":1,\"entries\":[{\"type\":\"minecraft:item\",\"name\":\"%output%\"}],\"conditions\":[{\"condition\":\"minecraft:survives_explosion\"}]}]}";
    private static final File OUTPUT_DIR = new File("dump/bookshelf");

    public BookshelfCommands(RegistryHelper registry) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"bookshelf");
        root.then(CommandUtils.createModCommand("validateLootTables", 2, this::validateLootTables));
        new CommandHand((LiteralArgumentBuilder<CommandSource>)root);
        registry.registerCommand((LiteralArgumentBuilder<CommandSource>)root);
    }

    private int validateLootTables(CommandContext<CommandSource> context, boolean wildcard) {
        String modId = wildcard ? "every mod" : ArgumentTypeMod.getMod(context, "mod");
        int foundIssues = 0;
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!wildcard && !block.getRegistryName().func_110624_b().equals(modId) || WorldUtils.doesLootTableExist(((CommandSource)context.getSource()).func_197023_e(), block.func_220068_i())) continue;
            ResourceLocation id = block.getRegistryName();
            File outputFile = new File(OUTPUT_DIR, "data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
            try {
                FileUtils.forceMkdir((File)outputFile.getParentFile());
                try (FileWriter writer = new FileWriter(outputFile);){
                    writer.write(LOOT_TABLE_BLOCK_DROP_SELF.replace("%output%", id.toString()));
                }
            }
            catch (IOException e) {
                Bookshelf.LOG.error("Failed to write dummy block loot table.", (Throwable)e);
            }
            ++foundIssues;
        }
        if (wildcard) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.bookshelf.loot_tables.wildcard", new Object[]{foundIssues}), false);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.bookshelf.loot_tables", new Object[]{foundIssues, modId}), false);
        }
        return 0;
    }
}

