/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.model;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CachedDynamicBakedModel
implements IBakedModel {
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private final IBakedModel bakedOriginal;
    private final IModel<?> raw;

    public CachedDynamicBakedModel(IBakedModel standard, IModel<?> tableModel) {
        this.bakedOriginal = standard;
        this.raw = tableModel;
    }

    public abstract String getCacheKey(BlockState var1, Direction var2);

    public abstract String getCacheKey(ItemStack var1, World var2, LivingEntity var3);

    public abstract IBakedModel generateBlockModel(String var1);

    public IBakedModel getBakedOriginal() {
        return this.bakedOriginal;
    }

    public IModel<?> getRaw() {
        return this.raw;
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.getModel(this.getCacheKey(state, side)).func_200117_a(state, side, rand);
    }

    public IBakedModel getModel(String key) {
        IBakedModel cachedModel;
        if (this.cache.containsKey(key) && (cachedModel = this.cache.get(key)) != null) {
            return cachedModel;
        }
        IBakedModel newModel = this.generateBlockModel(key);
        if (key != null) {
            this.cache.put(key, newModel);
        }
        return newModel;
    }

    public boolean func_177555_b() {
        return this.bakedOriginal.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedOriginal.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedOriginal.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedOriginal.func_177554_e();
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.bakedOriginal.func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
        Pair pair = this.bakedOriginal.handlePerspective(transformType);
        return Pair.of((Object)this, (Object)pair.getRight());
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListRetexturable.INSTANCE;
    }

    private static class ItemOverrideListRetexturable
    extends ItemOverrideList {
        public static final ItemOverrideList INSTANCE = new ItemOverrideListRetexturable();

        private ItemOverrideListRetexturable() {
        }

        public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, ItemStack stack, World world, LivingEntity entity) {
            if (originalModel instanceof CachedDynamicBakedModel) {
                CachedDynamicBakedModel rextexturable = (CachedDynamicBakedModel)originalModel;
                return rextexturable.getModel(rextexturable.getCacheKey(stack, world, entity));
            }
            return originalModel;
        }
    }
}

