/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderUtils {
    public static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Random ITEM_RANDOM = new Random();
    public static final IQuadColorHandler DEFAULT_QUAD_COLORS = (stack, quad, providedColor) -> {
        if (providedColor != -1 || stack.func_190926_b() || !quad.func_178212_b()) {
            return providedColor;
        }
        int color = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
        return color |= 0xFF000000;
    };
    private static final VertexFormat ITEM_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);

    public static TextureAtlasSprite getParticleTexture(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public static IBakedModel getBakedModel(ModelResourceLocation name) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(name);
    }

    public static IBakedModel getBakedModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static TextureAtlasSprite getSprite(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static IBakedModel getModelForState(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public static void saveTextureToFile(int textureId, File file) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int size = width * height;
        BufferedImage bufferedimage = new BufferedImage(width, height, 2);
        IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
        int[] data = new int[size];
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        buffer.get(data);
        bufferedimage.setRGB(0, 0, width, height, data, 0, width);
        try {
            ImageIO.write((RenderedImage)bufferedimage, "png", file);
        }
        catch (Exception e) {
            Bookshelf.LOG.error("Failed to save texture {} to {}.", (Object)textureId, (Object)file.getName());
            Bookshelf.LOG.catching((Throwable)e);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> copyTransforms(IBakedModel model) {
        ImmutableMap.Builder copiedTransforms = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            copiedTransforms.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return copiedTransforms.build();
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBasicTransforms(IBakedModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static void renderItemAndEffectIntoGUI(ItemStack stack, int xPosition, int yPosition, int color) {
        RenderUtils.renderItemAndEffectIntoGUI(stack, xPosition, yPosition, color, DEFAULT_QUAD_COLORS);
    }

    public static void renderItemAndEffectIntoGUI(ItemStack stack, int xPosition, int yPosition, int color, IQuadColorHandler colorHandler) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderUtils.renderItemAndEffectIntoGUI(mc.func_110434_K(), mc.func_175599_af(), (LivingEntity)mc.field_71439_g, stack, xPosition, yPosition, color, colorHandler);
    }

    public static void renderItemAndEffectIntoGUI(TextureManager textureManager, ItemRenderer itemRenderer, @Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y, int color) {
        RenderUtils.renderItemAndEffectIntoGUI(textureManager, itemRenderer, entityIn, itemIn, x, y, color, DEFAULT_QUAD_COLORS);
    }

    public static void renderItemAndEffectIntoGUI(TextureManager textureManager, ItemRenderer itemRenderer, @Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y, int color, IQuadColorHandler colorHandler) {
        if (!itemIn.func_190926_b()) {
            itemRenderer.field_77023_b += 50.0f;
            try {
                RenderUtils.renderItemModelIntoGUI(textureManager, itemRenderer, itemIn, x, y, color, itemRenderer.func_184393_a(itemIn, (World)null, entityIn), colorHandler);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", () -> String.valueOf(itemIn.func_77973_b()));
                crashreportcategory.func_189529_a("Registry Name", () -> String.valueOf(itemIn.func_77973_b().getRegistryName()));
                crashreportcategory.func_189529_a("Item Damage", () -> String.valueOf(itemIn.func_77952_i()));
                crashreportcategory.func_189529_a("Item NBT", () -> String.valueOf(itemIn.func_77978_p()));
                crashreportcategory.func_189529_a("Item Foil", () -> String.valueOf(itemIn.func_77962_s()));
                throw new ReportedException(crashreport);
            }
            itemRenderer.field_77023_b -= 50.0f;
        }
    }

    public static void renderItemModelIntoGUI(TextureManager textureManager, ItemRenderer itemRenderer, ItemStack stack, int x, int y, int color, IBakedModel bakedmodel) {
        RenderUtils.renderItemModelIntoGUI(textureManager, itemRenderer, stack, x, y, color, bakedmodel, DEFAULT_QUAD_COLORS);
    }

    public static void renderItemModelIntoGUI(TextureManager textureManager, ItemRenderer itemRenderer, ItemStack stack, int x, int y, int color, IBakedModel bakedmodel, IQuadColorHandler colorHandler) {
        GlStateManager.pushMatrix();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.setupGuiTransform(x, y, bakedmodel.func_177556_c(), itemRenderer.field_77023_b);
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        RenderUtils.renderItem(itemRenderer, stack, bakedmodel, color, colorHandler);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        GlStateManager.translatef((float)xPosition, (float)yPosition, (float)(100.0f + zLevel));
        GlStateManager.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.enableLighting();
        } else {
            GlStateManager.disableLighting();
        }
    }

    public static void renderItem(ItemRenderer itemRenderer, ItemStack stack, IBakedModel model, int color) {
        RenderUtils.renderItem(itemRenderer, stack, model, color, DEFAULT_QUAD_COLORS);
    }

    public static void renderItem(ItemRenderer itemRenderer, ItemStack stack, IBakedModel model, int color, IQuadColorHandler colorHandler) {
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            RenderUtils.renderModel(itemRenderer, model, color, stack, colorHandler);
            GlStateManager.popMatrix();
        }
    }

    public static void renderModel(ItemRenderer itemRenderer, IBakedModel model, int color, ItemStack stack) {
        RenderUtils.renderModel(itemRenderer, model, color, stack, DEFAULT_QUAD_COLORS);
    }

    public static void renderModel(ItemRenderer itemRenderer, IBakedModel model, int color, ItemStack stack, IQuadColorHandler colorHandler) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (Direction direction : Direction.values()) {
            ITEM_RANDOM.setSeed(42L);
            RenderUtils.renderQuads(bufferbuilder, model.func_200117_a((BlockState)null, direction, ITEM_RANDOM), color, stack, colorHandler);
        }
        ITEM_RANDOM.setSeed(42L);
        RenderUtils.renderQuads(bufferbuilder, model.func_200117_a((BlockState)null, (Direction)null, ITEM_RANDOM), color, stack, colorHandler);
        tessellator.func_78381_a();
    }

    public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        RenderUtils.renderQuads(renderer, quads, color, stack, DEFAULT_QUAD_COLORS);
    }

    public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack, IQuadColorHandler colorHandler) {
        for (BakedQuad quad : quads) {
            int quadColor = colorHandler.getColorForQuad(stack, quad, color);
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)quadColor);
        }
    }

    public static void drawTexturedRect(int x, int y, int z, float u, float v, int width, int height, float textureWidth, float textureHeight, int color) {
        RenderUtils.drawTexturedRect(x, y, z, u, v, width, height, textureWidth, textureHeight, color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, color >> 24 & 0xFF);
    }

    public static void drawTexturedRect(int x, int y, int z, float u, float v, int width, int height, float textureWidth, float textureHeight, int red, int green, int blue, int alpha) {
        float widthRatio = 1.0f / textureWidth;
        float heightRatio = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * widthRatio), (double)((v + (float)height) * heightRatio)).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * widthRatio), (double)((v + (float)height) * heightRatio)).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * widthRatio), (double)(v * heightRatio)).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * widthRatio), (double)(v * heightRatio)).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean isForgeLightingPipeline() {
        return (Boolean)ForgeConfig.CLIENT.forgeLightPipelineEnabled.get();
    }

    public static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (RenderUtils.isForgeLightingPipeline() && format != DefaultVertexFormats.field_176600_a) {
            if (format == DefaultVertexFormats.field_176599_b) {
                return ITEM_WITH_LIGHTMAP;
            }
            if (!format.func_207750_a(1)) {
                VertexFormat copy = new VertexFormat(format);
                copy.func_181721_a(DefaultVertexFormats.field_181716_p);
                return copy;
            }
        }
        return format;
    }

    @FunctionalInterface
    public static interface IQuadColorHandler {
        public int getColorForQuad(ItemStack var1, BakedQuad var2, int var3);
    }
}

