/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;

public final class ModUtils {
    public static boolean isInModList(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Nullable
    public static <T> T callIfPresent(String modid, Supplier<Callable<T>> toRun) {
        return ModUtils.callIfPresent(modid, toRun, null);
    }

    @Nullable
    public static <T> T callIfPresent(String modid, Supplier<Callable<T>> ifPresent, @Nullable Supplier<Callable<T>> notPresent) {
        try {
            if (ModUtils.isInModList(modid)) {
                return ifPresent.get().call();
            }
            if (notPresent != null) {
                return notPresent.get().call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void runIfPresent(String modid, Supplier<Runnable> ifPresent) {
        ModUtils.runIfPresent(modid, ifPresent, null);
    }

    public static void runIfPresent(String modid, Supplier<Runnable> ifPresent, @Nullable Supplier<Runnable> notPresent) {
        if (ModUtils.isInModList(modid)) {
            ifPresent.get().run();
        } else if (notPresent != null) {
            notPresent.get().run();
        }
    }

    public static <T> T supplyIfPresent(String modid, Supplier<Supplier<T>> ifPresent) {
        return ModUtils.supplyIfPresent(modid, ifPresent, null);
    }

    @Nullable
    public static <T> T supplyIfPresent(String modid, Supplier<Supplier<T>> ifPresent, @Nullable Supplier<Supplier<T>> notPresent) {
        if (ModUtils.isInModList(modid)) {
            return ifPresent.get().get();
        }
        if (notPresent != null) {
            return notPresent.get().get();
        }
        return null;
    }
}

