/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.List;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public final class EntityUtils {
    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsUtils.getDistanceBetweenPoints(firstEntity.func_174791_d(), secondEntity.func_174791_d());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsUtils.getDistanceBetweenPoints(entity.func_174791_d(), new Vec3d((Vec3i)pos));
    }

    public static void pushTowards(Entity entityToMove, Direction direction, double force) {
        EntityUtils.pushTowards(entityToMove, entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        double distanceX = (double)pos.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)pos.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vec3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceX = destination.field_70165_t - entityToMove.field_70165_t;
        double distanceY = destination.field_70163_u - entityToMove.field_70163_u;
        double distanceZ = destination.field_70161_v - entityToMove.field_70161_v;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vec3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowardsDirection(Entity entityToMove, Direction direction, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        BlockPos destination = entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1);
        double distanceX = (double)destination.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)destination.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vec3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityUtils.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T> List<T> getEntitiesInArea(Class<? extends Entity> entityClass, World world, BlockPos pos, int range) {
        return world.func_217357_a(entityClass, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
    }

    public static boolean isWearingFullSet(MobEntity living, Class<Item> armorClass) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack armor;
            if (!slot.func_188453_a().equals((Object)EquipmentSlotType.Group.ARMOR) || !(armor = living.func_184582_a(slot)).func_190926_b() && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static double getMaxHealth(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    public static double getFollowRange(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
    }

    public static double getKnockbackResistance(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
    }

    public static double getMovementSpeed(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    public static double getAttackDamage(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public static double getAttackSpeed(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e();
    }

    public static double getArmor(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
    }

    public static double getArmorToughness(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e();
    }

    public static double getLuck(MobEntity entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188792_h).func_111126_e();
    }

    public static double getValue(MobEntity entity, IAttribute attribute) {
        return entity.func_110148_a(attribute).func_111126_e();
    }

    public static void addDrop(ItemStack stack, LivingDropsEvent event) {
        LivingEntity living = event.getEntityLiving();
        ItemEntity droppedItemEntity = new ItemEntity(event.getEntityLiving().field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, stack);
        droppedItemEntity.func_174869_p();
        event.getDrops().add(droppedItemEntity);
    }
}

