/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.client.model.DelegateBakedModel;
import net.darkhax.bookshelf.util.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class FullbrightBakedModel
extends DelegateBakedModel {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            return FullbrightBakedModel.transformQuads(key.base.getQuads(key.state, key.side, key.random, (IModelData)EmptyModelData.INSTANCE), key.textures);
        }
    });
    private final Map<ResourceLocation, Float> textureLightValues = new HashMap<ResourceLocation, Float>();
    private boolean cacheDisabled = false;

    public FullbrightBakedModel(IBakedModel base) {
        super(base);
    }

    public FullbrightBakedModel(IBakedModel base, Float light, ResourceLocation ... textures) {
        this(base);
        for (ResourceLocation texture : textures) {
            this.setLightLevel(texture, light.floatValue());
        }
    }

    public void setLightLevel(ResourceLocation texture, float light) {
        this.textureLightValues.put(texture, Float.valueOf(light));
    }

    public FullbrightBakedModel disableCache() {
        this.cacheDisabled = true;
        return this;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        if (state == null) {
            return this.delegateModel.getQuads(state, side, rand, data);
        }
        if (this.cacheDisabled) {
            return FullbrightBakedModel.transformQuads(this.delegateModel.getQuads(state, side, rand, data), this.textureLightValues);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.delegateModel, this.textureLightValues, rand, state, side));
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, Map<ResourceLocation, Float> textures) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            ResourceLocation texture = quad.func_187508_a().func_195668_m();
            if (!textures.containsKey(texture)) continue;
            quads.set(i, FullbrightBakedModel.transformQuad(quad, textures.get(texture).floatValue()));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad, final float light) {
        if (RenderUtils.isForgeLightingPipeline()) {
            VertexFormat newFormat = RenderUtils.getFormatWithLightMap(quad.getFormat());
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
            VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

                protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                    lightmap[0] = light;
                    lightmap[1] = light;
                }

                public void setQuadTint(int tint) {
                }
            };
            trans.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)trans);
            builder.setQuadTint(quad.func_178211_c());
            builder.setQuadOrientation(quad.func_178210_d());
            builder.setTexture(quad.func_187508_a());
            builder.setApplyDiffuseLighting(false);
            return builder.build();
        }
        return quad;
    }

    private class CacheKey {
        private final IBakedModel base;
        private final Map<ResourceLocation, Float> textures;
        private final Random random;
        private final BlockState state;
        private final Direction side;

        public CacheKey(IBakedModel base, Map<ResourceLocation, Float> textures, Random random, BlockState state, Direction side) {
            this.base = base;
            this.textures = textures;
            this.random = random;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (cacheKey.side != this.side) {
                return false;
            }
            return this.state.equals((Object)cacheKey.state);
        }

        public int hashCode() {
            return this.state.hashCode() + 31 * (this.side != null ? this.side.hashCode() : 0);
        }
    }
}

