/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf;

import net.darkhax.bookshelf.BookshelfConfig;
import net.darkhax.bookshelf.BookshelfRegistry;
import net.darkhax.bookshelf.client.RomanNumerals;
import net.darkhax.bookshelf.crafting.IAnvilRecipe;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.AnnotationUtils;
import net.darkhax.bookshelf.util.OreDictUtils;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.bookshelf.world.gamerule.GameRule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="bookshelf", name="Bookshelf", version="2.3.576", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class Bookshelf {
    public static final LoggingHelper LOG = new LoggingHelper("Bookshelf");

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        AnnotationUtils.setAnnotationData(event.getASMHarvestedData());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new BookshelfConfig(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictUtils.initAdditionalVanillaEntries();
        for (RegistryHelper helper : RegistryHelper.getAllHelpers()) {
            if (!helper.hasAutoRegistry()) continue;
            helper.getAutoRegistry().init();
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void clientInit(FMLInitializationEvent event) {
        for (RegistryHelper helper : RegistryHelper.getAllHelpers()) {
            if (!helper.hasAutoRegistry()) continue;
            helper.getAutoRegistry().clientInit();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        for (ICommand command : BookshelfRegistry.getCommands()) {
            event.registerServerCommand(command);
        }
    }

    @SubscribeEvent
    public void onWorldLoaded(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            for (GameRule rule : BookshelfRegistry.getGameRules()) {
                rule.initialize(event.getWorld());
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        for (IAnvilRecipe recipe : BookshelfRegistry.getAnvilRecipes()) {
            if (!recipe.isValidRecipe(event.getLeft(), event.getRight(), event.getName())) continue;
            event.setCost(recipe.getExperienceCost(event.getLeft(), event.getRight(), event.getName()));
            event.setMaterialCost(recipe.getMaterialCost(event.getLeft(), event.getRight(), event.getName()));
            event.setOutput(recipe.getOutput(event.getLeft(), event.getRight(), event.getName()));
            return;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (RenderUtils.requireRenderReload()) {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
            RenderUtils.markRenderersForReload(false);
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        RomanNumerals.insertRomanNumerals();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(listener -> RomanNumerals.insertRomanNumerals());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        Constants.LOG.error("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!", new Object[0]);
    }
}

