/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.List;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public final class EntityUtils {
    private static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    private EntityUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsUtils.getDistanceBetweenPoints(firstEntity.func_174791_d(), secondEntity.func_174791_d());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsUtils.getDistanceBetweenPoints(entity.func_174791_d(), new Vec3d((Vec3i)pos));
    }

    public static void pushTowards(Entity entityToMove, EnumFacing direction, double force) {
        EntityUtils.pushTowards(entityToMove, entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        double distanceX = (double)pos.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)pos.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceX = destination.field_70165_t - entityToMove.field_70165_t;
        double distanceY = destination.field_70163_u - entityToMove.field_70163_u;
        double distanceZ = destination.field_70161_v - entityToMove.field_70161_v;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
        }
    }

    public static Vec3d pushTowardsDirection(Entity entityToMove, EnumFacing direction, double force) {
        Vec3d vec3d;
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        BlockPos destination = entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1);
        double distanceX = (double)destination.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)destination.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
            Vec3d vec3d2 = new Vec3d(entityToMove.field_70159_w, entityToMove.field_70181_x, entityToMove.field_70179_y);
            vec3d = vec3d2;
        } else {
            vec3d = new Vec3d(0.0, 0.0, 0.0);
        }
        return vec3d;
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityUtils.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T> List<T> getEntitiesInArea(Class<? extends Entity> entityClass, World world, BlockPos pos, int range) {
        return world.func_72872_a(entityClass, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
    }

    public static EntityEquipmentSlot getEquipmentSlot(int index) {
        if (index >= 0 && index < EQUIPMENT_SLOTS.length) {
            return EQUIPMENT_SLOTS[index];
        }
        return null;
    }

    public static boolean isWearingFullSet(EntityLivingBase living, Class<Item> armorClass) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack armor;
            if (!slot.func_188453_a().equals((Object)EntityEquipmentSlot.Type.ARMOR) || !(armor = living.func_184582_a(slot)).func_190926_b() && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static void enderTeleport(EntityLivingBase entity, int dimension, double x, double y, double z, float damage) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, damage);
        if (!event.isCanceled()) {
            entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            entity.field_70143_R = 0.0f;
            if (damage > 0.0f) {
                entity.func_70097_a(DamageSource.field_76379_h, event.getAttackDamage());
            }
            if (entity.field_71093_bK != dimension) {
                if (PlayerUtils.isPlayerReal((Entity)entity)) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    PlayerUtils.changeDimension(player, dimension);
                } else {
                    entity.func_184204_a(dimension);
                }
            }
        }
    }

    public static void changeWorld(Entity entity, WorldServer worldOld, WorldServer worldNew) {
        WorldProvider providerOld = worldOld.field_73011_w;
        WorldProvider providerNew = worldNew.field_73011_w;
        double moveFactor = providerOld.getMovementFactor() / providerNew.getMovementFactor();
        double x = MathHelper.func_151237_a((double)(entity.field_70165_t * moveFactor), (double)-2.9999872E7, (double)2.9999872E7);
        double z = MathHelper.func_151237_a((double)(entity.field_70161_v * moveFactor), (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            worldNew.func_72838_d(entity);
            worldNew.func_72866_a(entity, false);
        }
        entity.func_70029_a((World)worldNew);
    }

    public static double getMaxHealth(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    public static double getFollowRange(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
    }

    public static double getKnockbackResistance(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
    }

    public static double getMovementSpeed(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    public static double getAttackDamage(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public static double getAttackSpeed(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e();
    }

    public static double getArmor(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
    }

    public static double getArmorToughness(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e();
    }

    public static double getLuck(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_188792_h).func_111126_e();
    }

    public static double getAttributeValue(EntityLivingBase entity, IAttribute attribute) {
        return entity.func_110148_a(attribute).func_111126_e();
    }
}

