/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import javax.annotation.Nonnull;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public final class BlockUtils {
    private BlockUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isOre(@Nonnull ItemStack stack, boolean checkName) {
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockOre) {
            return true;
        }
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oreID).startsWith("ore")) continue;
            return true;
        }
        return checkName && stack.func_77973_b().func_77653_i(stack).matches(".*(^|\\s)([oO]re)($|\\s).");
    }

    public static boolean isFluid(Block block) {
        return block == Blocks.field_150353_l || block == Blocks.field_150355_j || block instanceof IFluidBlock;
    }

    public static boolean isFluidFull(World world, BlockPos pos) {
        return BlockUtils.isFluidFull(BlockUtils.getActualState(world, pos));
    }

    public static boolean isFluidFull(IBlockState state) {
        return BlockUtils.getFluidLevel(state) == 0;
    }

    public static int getFluidLevel(World world, BlockPos pos) {
        return BlockUtils.getFluidLevel(BlockUtils.getActualState(world, pos));
    }

    public static int getFluidLevel(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
    }

    public static FluidStack getFluid(World world, BlockPos pos) {
        IBlockState state = BlockUtils.getActualState(world, pos);
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, pos)) {
            return ((IFluidBlock)block).drain(world, pos, true);
        }
        if (block instanceof BlockStaticLiquid && BlockUtils.isFluidFull(state)) {
            Fluid fluid;
            Object object = block == Blocks.field_150355_j ? FluidRegistry.WATER : (fluid = block == Blocks.field_150353_l ? FluidRegistry.LAVA : null);
            if (fluid != null) {
                return new FluidStack(fluid, 1000);
            }
        }
        return null;
    }

    public static IBlockState getActualState(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
    }

    public static float getModifiedBreakSpeed(float desiredBreakSpeed, float currentHardness, boolean canHarvest) {
        float speed = desiredBreakSpeed;
        speed *= currentHardness;
        return speed *= canHarvest ? 30.0f : 100.0f;
    }

    public static boolean canHarvestSafely(IBlockState state, EntityPlayer player) {
        try {
            Block block = state.func_177230_c();
            if (state.func_185904_a().func_76229_l()) {
                return true;
            }
            ItemStack stack = player.func_184614_ca();
            String tool = block.getHarvestTool(state);
            if (stack.func_190926_b() || tool == null) {
                return player.func_184823_b(state);
            }
            int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
            if (toolLevel < 0) {
                return player.func_184823_b(state);
            }
            return toolLevel >= block.getHarvestLevel(state);
        }
        catch (Exception e) {
            Constants.LOG.trace("Error checking harvest for " + state.toString(), e);
            return false;
        }
    }

    public static float getHardnessSafely(IBlockState state, World world, BlockPos pos) {
        try {
            return state.func_177230_c().func_176195_g(state, world, pos);
        }
        catch (Exception e) {
            Constants.LOG.trace("Error checking hardness for " + state.toString(), e);
            return 99999.0f;
        }
    }

    public static float getBreakSpeed(float playerDigSpeed, float hardness, boolean canHarvest) {
        return playerDigSpeed / hardness / (canHarvest ? 30.0f : 100.0f);
    }

    public static float blockStrengthSafely(@Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        try {
            float hardness = BlockUtils.getHardnessSafely(state, world, pos);
            if (hardness < 0.0f) {
                return 0.0f;
            }
            return player.getDigSpeed(state, pos) / hardness / (BlockUtils.canHarvestSafely(state, player) ? 30.0f : 100.0f);
        }
        catch (Exception e) {
            Constants.LOG.trace("Exception getting block strength! " + state.toString(), e);
            return 99999.0f;
        }
    }

    public static float getBreakSpeedToMatch(IBlockState current, IBlockState target, World world, EntityPlayer player, BlockPos pos) {
        float currentHardness = current.func_185887_b(world, pos);
        boolean currentCanHarvest = BlockUtils.canHarvestSafely(current, player);
        float targetSpeed = BlockUtils.blockStrengthSafely(target, player, world, pos);
        float currentSpeed = BlockUtils.getModifiedBreakSpeed(targetSpeed, currentHardness, currentCanHarvest);
        return currentSpeed;
    }

    public static boolean isSlimeChunk(World world, BlockPos pos) {
        return world.func_175726_f(pos).func_76617_a(987234911L).nextInt(10) == 0;
    }
}

