package commonnetwork.networking.data;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record PacketContainer<T>(
        class_8710.class_9154<? extends class_8710> type,
        Class<T> classType,
        BiConsumer<T, class_2540> encoder,
        Function<class_2540, T> decoder,
        class_9139<? super class_2540, T> codec,
        Consumer<PacketContext<T>> handler,
        PacketType packetType)
{
    //TODO: Removing for mc 1.21.2 or 1.22
    @Deprecated(forRemoval = true)
    public PacketContainer(class_2960 id,
                           Class<T> classType,
                           BiConsumer<T, class_2540> encoder,
                           Function<class_2540, T> decoder,
                           Consumer<PacketContext<T>> handle)
    {
        this(new class_8710.class_9154<>(id), classType, encoder, decoder, null, handle, PacketType.PLAY);
    }

    @SuppressWarnings("unchecked")
    public <B extends class_2540> PacketContainer(class_8710.class_9154<? extends class_8710> type,
                                                       Class<T> classType,
                                                       class_9139<? super B, T> codec,
                                                       Consumer<PacketContext<T>> handle,
                                                       PacketType packetType)
    {
        this(type, classType, null, null, (class_9139<? super class_2540, T>) codec, handle, packetType );
    }

    @SuppressWarnings("unchecked")
    public <K extends class_8710> class_8710.class_9154<K> getType()
    {
        return (class_8710.class_9154<K>) type();
    }

    //TODO: Removing for mc 1.21.2 or 1.22, will also be able to remove the wrapping of the decoder.
    @SuppressWarnings("unchecked")
    public <K extends class_2540> class_9139<K, CommonPacketWrapper> getCodec()
    {
        if (this.codec() == null)
        {
            // builds a codec from the supplied encoder and decoder.
            return class_8710.method_56484(
                    (packet, buf) -> this.encoder().accept((T) packet.packet(), buf),
                    (buf) -> new CommonPacketWrapper<>(this, this.decoder().apply(buf)));
        }
        else
        {
            return class_8710.method_56484(

                    (packet, buf) -> this.codec().encode(buf, (T) packet.packet()),
                    (buf) -> new CommonPacketWrapper<>(this, this.codec().decode(buf)));
        }
    }

    public enum PacketType
    {
        PLAY,
        CONFIGURATION
    }
}
