package commonnetwork.networking;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public interface PacketRegistrar
{
    /**
     * @return the side
     */
    Side getSide();

    /**
     * Packet Registration registers a PLAY packet
     *
     * @param packetIdentifier - The unique {@link class_2960} packet id.
     * @param packetClass      - The class of the packet.
     * @param encoder          - The encoder method.
     * @param decoder          - The decoder method.
     * @param handler          - The handler method.
     * @param <T>              - The class type
     * @return The registrar for chaining registrations.
     * @deprecated this method will eventually be removed, please migrate to the method supplying your own encoding/decoding codec. Likely in 1.21.2 or 1.22.
     */
    @Deprecated(forRemoval = true)
    <T> PacketRegistrar registerPacket(class_2960 packetIdentifier, Class<T> packetClass, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, Consumer<PacketContext<T>> handler);

    /**
     * Packet Registration, registers a PLAY packet
     *
     * @param type        - The packet type.
     * @param packetClass - The class of the packet.
     * @param codec       - The StreamCodec.
     * @param handler     - The handler method.
     * @param <T>         - The class type
     * @return The registrar for chaining registrations.
     */
    <T> PacketRegistrar registerPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler);

    /**
     * Packet Registration, registers a CONFIGURATION packet
     *
     * @param type        - The packet type.
     * @param packetClass - The class of the packet.
     * @param codec       - The StreamCodec.
     * @param handler     - The handler method.
     * @param <T>         - The class type
     * @return The registrar for chaining registrations.
     */
    <T> PacketRegistrar registerConfigurationPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler);
}
