package commonnetwork.api;

import commonnetwork.CommonNetworkMod;
import commonnetwork.networking.PacketRegistrar;
import commonnetwork.networking.data.PacketContext;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class Network
{
    /**
     * Packet Registration
     *
     * @param packetIdentifier - The unique {@link class_2960} packet id.
     * @param packetClass      - The class of the packet.
     * @param encoder          - The encoder method.
     * @param decoder          - The decoder method.
     * @param handler          - The handler method.
     * @param <T>              - The type
     * @return The registrar for chaining registrations.
     * @deprecated this method will eventually be removed, please migrate to the method supplying your own encoding/decoding codec. Likely in 1.21.2 or 1.22.
     */
    @Deprecated(forRemoval = true)
    public static <T> PacketRegistrar registerPacket(class_2960 packetIdentifier, Class<T> packetClass, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, Consumer<PacketContext<T>> handler)
    {
        return CommonNetworkMod.registerPacket(packetIdentifier, packetClass, encoder, decoder, handler);
    }

    /**
     * Packet Registration
     *
     * @param type        - The packet type.
     * @param packetClass - The class of the packet.
     * @param codec       - The StreamCodec.
     * @param handler     - The handler method.
     * @param <T>         - The class type
     * @return The registrar for chaining registrations.
     */
    public static <T> PacketRegistrar registerPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler)
    {
        return CommonNetworkMod.registerPacket(type, packetClass, codec, handler);
    }

    /**
     * Packet Registration
     *
     * @param type        - The packet type.
     * @param packetClass - The class of the packet.
     * @param codec       - The StreamCodec.
     * @param handler     - The handler method.
     * @param <T>         - The class type
     * @return The registrar for chaining registrations.
     */
    public static <T> PacketRegistrar registerConfigurationPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler)
    {
        return CommonNetworkMod.registerConfigurationPacket(type, packetClass, codec, handler);
    }

    /**
     * Gets the Network handler for use to send packets.
     *
     * @return - The network handler
     */
    public static NetworkHandler getNetworkHandler()
    {
        return CommonNetworkMod.INSTANCE.getPacketRegistration();
    }
}
