/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.startup.AbstractModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ForgeModIdHelper
extends AbstractModIdHelper {
    @Nullable
    private static ForgeModIdHelper INSTANCE;
    private final Map<String, ModContainer> modMap = Loader.instance().getIndexedModList();

    public static IModIdHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ForgeModIdHelper();
        }
        return INSTANCE;
    }

    private ForgeModIdHelper() {
    }

    @Override
    public String getModNameForModId(String modId) {
        ModContainer modContainer = this.modMap.get(modId);
        if (modContainer == null) {
            return modId;
        }
        return modContainer.getName();
    }

    @Override
    @Nullable
    public String getModNameTooltipFormatting() {
        try {
            String withoutFormatting;
            String lastLine;
            ItemStack itemStack = new ItemStack(Items.field_151034_e);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            List tooltip = new ArrayList<String>();
            tooltip.add("JEI Tooltip Testing for mod name formatting");
            ItemTooltipEvent tooltipEvent = ForgeEventFactory.onItemTooltip((ItemStack)itemStack, (EntityPlayer)player, tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            tooltip = tooltipEvent.getToolTip();
            if (tooltip.size() > 1 && (lastLine = (String)tooltip.get(tooltip.size() - 1)).contains("Minecraft") && (withoutFormatting = TextFormatting.func_110646_a((String)lastLine)) != null) {
                if (lastLine.equals(withoutFormatting)) {
                    return "";
                }
                if (lastLine.endsWith(withoutFormatting)) {
                    int i = lastLine.length() - withoutFormatting.length();
                    return lastLine.substring(0, i);
                }
            }
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().error("Error while Testing for mod name formatting", e);
        }
        return null;
    }
}

