/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.Config;
import mezz.jei.startup.IModIdHelper;

public abstract class AbstractModIdHelper
implements IModIdHelper {
    @Override
    public <T> String getModNameForIngredient(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String modId = ingredientHelper.getModId(ingredient);
        return this.getModNameForModId(modId);
    }

    @Override
    public <T> List<String> addModNameToIngredientTooltip(List<String> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (Config.isModNameFormatOverrideActive()) {
            return tooltip;
        }
        String modNameFormat = Config.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return tooltip;
        }
        String modName = this.getModNameForIngredient(ingredient, ingredientHelper);
        ArrayList<String> tooltipCopy = new ArrayList<String>(tooltip);
        tooltipCopy.add(modNameFormat + modName);
        return tooltipCopy;
    }
}

