/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.gui.recipes.RecipeInfoIcon;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class ShapelessRecipeWrapper<T extends IRecipe>
implements ICraftingRecipeWrapper {
    private final IJeiHelpers jeiHelpers;
    private final RecipeInfoIcon recipeInfoIcon;
    protected final T recipe;

    public ShapelessRecipeWrapper(IJeiHelpers jeiHelpers, T recipe) {
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
        this.recipeInfoIcon = new RecipeInfoIcon();
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ItemStack recipeOutput = this.recipe.func_77571_b();
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        try {
            List inputLists = stackHelper.expandRecipeItemStackInputs((List)this.recipe.func_192400_c());
            ingredients.setInputLists(ItemStack.class, inputLists);
            ingredients.setOutput(ItemStack.class, recipeOutput);
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe(this.recipe, (List)this.recipe.func_192400_c(), recipeOutput);
            throw new BrokenCraftingRecipeException(info, e);
        }
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        ResourceLocation registryName = this.recipe.getRegistryName();
        if (registryName != null) {
            this.recipeInfoIcon.draw(minecraft);
        }
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ResourceLocation registryName = this.recipe.getRegistryName();
        if (registryName != null) {
            return this.recipeInfoIcon.getTooltipStrings(registryName, mouseX, mouseY);
        }
        return Collections.emptyList();
    }
}

