/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Config;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.LegacyUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory category;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory category, int x, int y) {
        super(x, y);
        this.logic = logic;
        this.category = category;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.logic.setRecipeCategory(this.category);
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        return true;
    }

    @Override
    public void draw(Minecraft minecraft, boolean selected, int mouseX, int mouseY) {
        super.draw(minecraft, selected, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(minecraft, iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            List<Object> recipeCatalysts = this.logic.getRecipeCatalysts(this.category);
            if (!recipeCatalysts.isEmpty()) {
                Object ingredient = recipeCatalysts.get(0);
                RecipeCategoryTab.renderIngredient(minecraft, iconX, iconY, ingredient);
            } else {
                String text = this.category.getTitle().substring(0, 2);
                FontRenderer fontRenderer = minecraft.field_71466_p;
                float textCenterX = (float)this.x + 12.0f;
                float textCenterY = (float)this.y + 12.0f - 3.0f;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                fontRenderer.func_175063_a(text, textCenterX - (float)fontRenderer.func_78256_a(text) / 2.0f, textCenterY, color);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(Minecraft minecraft, int iconX, int iconY, T ingredient) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientRenderer<T> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredient);
        GlStateManager.func_179126_j();
        ingredientRenderer.render(minecraft, iconX, iconY, ingredient);
        GlStateManager.func_179141_d();
        GlStateManager.func_179097_i();
    }

    @Override
    public boolean isSelected(IRecipeCategory selectedCategory) {
        return this.category.getUid().equals(selectedCategory.getUid());
    }

    @Override
    public List<String> getTooltip() {
        String modName;
        ArrayList<String> tooltip = new ArrayList<String>();
        String title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        if ((modName = LegacyUtil.getModName(this.category)) != null) {
            modName = ForgeModIdHelper.getInstance().getModNameForModId(modName);
            tooltip.add(Config.getModNameFormat() + modName);
        }
        return tooltip;
    }
}

