/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.config.Constants;
import mezz.jei.gui.CraftingGridHelper;
import mezz.jei.gui.TickTimer;
import mezz.jei.gui.elements.DrawableAnimated;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.DrawableResource;
import mezz.jei.util.ErrorUtil;
import net.minecraft.util.ResourceLocation;

public class GuiHelper
implements IGuiHelper {
    private final IDrawableStatic slotDrawable = this.createDrawable(Constants.RECIPE_BACKGROUND, 196, 93, 18, 18);
    private final IDrawableStatic tabSelected = this.createDrawable(Constants.RECIPE_BACKGROUND, 196, 15, 24, 24);
    private final IDrawableStatic tabUnselected = this.createDrawable(Constants.RECIPE_BACKGROUND, 220, 15, 24, 22);
    private final IDrawableStatic shapelessIcon = this.createDrawable(Constants.RECIPE_BACKGROUND, 196, 0, 16, 15);
    private final IDrawableStatic infoIcon = this.createDrawable(Constants.RECIPE_BACKGROUND, 212, 39, 16, 16);
    private final IDrawableStatic arrowPrevious = this.createDrawable(Constants.RECIPE_BACKGROUND, 196, 55, 5, 8, 1, 0, 0, 0);
    private final IDrawableStatic arrowNext = this.createDrawable(Constants.RECIPE_BACKGROUND, 204, 55, 5, 8, 1, 0, 1, 0);
    private final IDrawableStatic plusSign = this.createDrawable(Constants.RECIPE_BACKGROUND, 212, 55, 6, 6, 1, 0, 1, 0);

    @Override
    public IDrawableStatic createDrawable(ResourceLocation resourceLocation, int u, int v, int width, int height) {
        ErrorUtil.checkNotNull(resourceLocation, "resourceLocation");
        return new DrawableResource(resourceLocation, u, v, width, height, 0, 0, 0, 0, 256, 256);
    }

    @Override
    public IDrawableStatic createDrawable(ResourceLocation resourceLocation, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        ErrorUtil.checkNotNull(resourceLocation, "resourceLocation");
        return new DrawableResource(resourceLocation, u, v, width, height, 0, 0, 0, 0, textureWidth, textureHeight);
    }

    @Override
    public IDrawableStatic createDrawable(ResourceLocation resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        ErrorUtil.checkNotNull(resourceLocation, "resourceLocation");
        return new DrawableResource(resourceLocation, u, v, width, height, paddingTop, paddingBottom, paddingLeft, paddingRight, 256, 256);
    }

    @Override
    public IDrawableAnimated createAnimatedDrawable(IDrawableStatic drawable, int ticksPerCycle, IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        ErrorUtil.checkNotNull(drawable, "drawable");
        ErrorUtil.checkNotNull(startDirection, "startDirection");
        IDrawableAnimated.StartDirection animationStartDirection = startDirection;
        if (inverted) {
            animationStartDirection = startDirection == IDrawableAnimated.StartDirection.TOP ? IDrawableAnimated.StartDirection.BOTTOM : (startDirection == IDrawableAnimated.StartDirection.BOTTOM ? IDrawableAnimated.StartDirection.TOP : (startDirection == IDrawableAnimated.StartDirection.LEFT ? IDrawableAnimated.StartDirection.RIGHT : IDrawableAnimated.StartDirection.LEFT));
        }
        int tickTimerMaxValue = animationStartDirection == IDrawableAnimated.StartDirection.TOP || animationStartDirection == IDrawableAnimated.StartDirection.BOTTOM ? drawable.getHeight() : drawable.getWidth();
        ITickTimer tickTimer = this.createTickTimer(ticksPerCycle, tickTimerMaxValue, !inverted);
        return new DrawableAnimated(drawable, tickTimer, animationStartDirection);
    }

    @Override
    public IDrawableStatic getSlotDrawable() {
        return this.slotDrawable;
    }

    @Override
    public IDrawableStatic createBlankDrawable(int width, int height) {
        return new DrawableBlank(width, height);
    }

    @Override
    public ICraftingGridHelper createCraftingGridHelper(int craftInputSlot1, int craftOutputSlot) {
        return new CraftingGridHelper(craftInputSlot1, craftOutputSlot);
    }

    @Override
    public ITickTimer createTickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        return new TickTimer(ticksPerCycle, maxValue, countDown);
    }

    public IDrawableStatic getTabSelected() {
        return this.tabSelected;
    }

    public IDrawableStatic getTabUnselected() {
        return this.tabUnselected;
    }

    public IDrawableStatic getShapelessIcon() {
        return this.shapelessIcon;
    }

    public IDrawableStatic getInfoIcon() {
        return this.infoIcon;
    }

    public IDrawableStatic getArrowPrevious() {
        return this.arrowPrevious;
    }

    public IDrawableStatic getArrowNext() {
        return this.arrowNext;
    }

    public IDrawableStatic getPlusSign() {
        return this.plusSign;
    }
}

