/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientInformation;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.LegacyUtil;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientListElement<V>
implements IIngredientListElement<V> {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final Map<String, Integer> WILDCARD_ADDED_ORDER = new HashMap<String, Integer>();
    private static int ADDED_INDEX = 0;
    private final V ingredient;
    private final int orderIndex;
    private final IIngredientHelper<V> ingredientHelper;
    private final IIngredientRenderer<V> ingredientRenderer;
    private final String displayName;
    private final String modName;
    private final String modId;
    private final String resourceId;
    private boolean hidden = false;

    @Nullable
    public static <V> IngredientListElement<V> create(V ingredient, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer, IModIdHelper modIdHelper) {
        try {
            int orderIndex;
            String uid = ingredientHelper.getWildcardId(ingredient);
            if (WILDCARD_ADDED_ORDER.containsKey(uid)) {
                orderIndex = WILDCARD_ADDED_ORDER.get(uid);
            } else {
                WILDCARD_ADDED_ORDER.put(uid, ADDED_INDEX);
                orderIndex = ADDED_INDEX++;
            }
            return new IngredientListElement<V>(ingredient, orderIndex, ingredientHelper, ingredientRenderer, modIdHelper);
        }
        catch (RuntimeException e) {
            try {
                String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.get().warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                Log.get().warn("Found a broken ingredient.", (Throwable)e2);
            }
            return null;
        }
    }

    protected IngredientListElement(V ingredient, int orderIndex, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer, IModIdHelper modIdHelper) {
        this.ingredient = ingredient;
        this.orderIndex = orderIndex;
        this.ingredientHelper = ingredientHelper;
        this.ingredientRenderer = ingredientRenderer;
        this.modId = ingredientHelper.getModId(ingredient);
        this.modName = modIdHelper.getModNameForModId(this.modId);
        this.displayName = IngredientInformation.getDisplayName(ingredient, ingredientHelper);
        this.resourceId = LegacyUtil.getResourceId(ingredient, ingredientHelper);
    }

    @Override
    public final V getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getOrderIndex() {
        return this.orderIndex;
    }

    @Override
    public IIngredientHelper<V> getIngredientHelper() {
        return this.ingredientHelper;
    }

    @Override
    public IIngredientRenderer<V> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getModName() {
        return this.modName;
    }

    @Override
    public Set<String> getModNameStrings() {
        String modNameLowercase = this.modName.toLowerCase(Locale.ENGLISH);
        String modNameNoSpaces = SPACE_PATTERN.matcher(modNameLowercase).replaceAll("");
        String modIdNoSpaces = SPACE_PATTERN.matcher(this.modId).replaceAll("");
        return ImmutableSet.of((Object)modNameLowercase, (Object)this.modId, (Object)modNameNoSpaces, (Object)modIdNoSpaces);
    }

    @Override
    public final List<String> getTooltipStrings() {
        String modNameLowercase = this.modName.toLowerCase(Locale.ENGLISH);
        String displayNameLowercase = Translator.toLowercaseWithLocale(this.displayName);
        return IngredientInformation.getTooltipStrings(this.ingredient, this.ingredientHelper, this.ingredientRenderer, (Set<String>)ImmutableSet.of((Object)this.modId, (Object)modNameLowercase, (Object)displayNameLowercase, (Object)this.resourceId));
    }

    @Override
    public Collection<String> getOreDictStrings() {
        ArrayList<String> oreDictStrings = new ArrayList<String>();
        if (this.ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)this.ingredient;
            for (int oreId : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                String oreNameLowercase = OreDictionary.getOreName((int)oreId).toLowerCase(Locale.ENGLISH);
                oreDictStrings.add(oreNameLowercase);
            }
        }
        return oreDictStrings;
    }

    @Override
    public Collection<String> getCreativeTabsStrings() {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        if (this.ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)this.ingredient;
            Item item = itemStack.func_77973_b();
            for (CreativeTabs creativeTab : item.getCreativeTabs()) {
                if (creativeTab == null) continue;
                String creativeTabName = I18n.func_135052_a((String)creativeTab.func_78024_c(), (Object[])new Object[0]);
                String creativeTabNameLowercase = Translator.toLowercaseWithLocale(creativeTabName);
                creativeTabsStrings.add(creativeTabNameLowercase);
            }
        }
        return creativeTabsStrings;
    }

    @Override
    public Collection<String> getColorStrings() {
        return IngredientInformation.getColorStrings(this.ingredient, this.ingredientHelper);
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

