/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.SessionData;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.render.GuiIngredientFast;
import mezz.jei.util.MathUtil;

public class IngredientGridAll
extends IngredientGrid {
    private final IngredientFilter ingredientFilter;

    public IngredientGridAll(IIngredientRegistry ingredientRegistry, IngredientFilter ingredientFilter) {
        super(ingredientRegistry);
        this.ingredientFilter = ingredientFilter;
    }

    @Override
    public void updateLayout(Collection<Rectangle> guiExclusionAreas) {
        super.updateLayout(guiExclusionAreas);
        List<IIngredientListElement> ingredientList = this.ingredientFilter.getIngredientList();
        this.guiIngredientList.set(SessionData.getFirstItemIndex(), ingredientList);
    }

    @Override
    public boolean nextPage() {
        int itemsCount = this.ingredientFilter.size();
        if (itemsCount > 0) {
            SessionData.setFirstItemIndex(SessionData.getFirstItemIndex() + this.guiIngredientList.size());
            if (SessionData.getFirstItemIndex() >= itemsCount) {
                SessionData.setFirstItemIndex(0);
            }
            return true;
        }
        SessionData.setFirstItemIndex(0);
        return false;
    }

    @Override
    public boolean previousPage() {
        int itemsPerPage = this.guiIngredientList.size();
        if (itemsPerPage == 0) {
            SessionData.setFirstItemIndex(0);
            return false;
        }
        int itemsCount = this.ingredientFilter.size();
        int pageNum = SessionData.getFirstItemIndex() / itemsPerPage;
        pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
        SessionData.setFirstItemIndex(itemsPerPage * pageNum);
        if (SessionData.getFirstItemIndex() > 0 && SessionData.getFirstItemIndex() == itemsCount) {
            SessionData.setFirstItemIndex(itemsPerPage * --pageNum);
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        int itemsPerPage = this.guiIngredientList.size();
        return itemsPerPage > 0 && this.ingredientFilter.size() > itemsPerPage;
    }

    @Override
    public boolean hasPrevious() {
        int itemsPerPage = this.guiIngredientList.size();
        return itemsPerPage > 0 && this.ingredientFilter.size() > itemsPerPage;
    }

    @Override
    public List<IIngredientListElement> getVisibleElements() {
        ArrayList<IIngredientListElement> visibleElements = new ArrayList<IIngredientListElement>();
        for (GuiIngredientFast guiItemStack : this.guiIngredientList.getAllGuiIngredients()) {
            IIngredientListElement element = guiItemStack.getElement();
            if (element == null) continue;
            visibleElements.add(element);
        }
        return visibleElements;
    }

    @Override
    public int getPageCount() {
        int itemCount = this.ingredientFilter.size();
        int stacksPerPage = this.guiIngredientList.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
        pageCount = Math.max(1, pageCount);
        return pageCount;
    }

    @Override
    public int getPageNum() {
        int stacksPerPage = this.guiIngredientList.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        return SessionData.getFirstItemIndex() / stacksPerPage;
    }
}

