/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.runtime;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubtypeRegistry
implements ISubtypeRegistry {
    private final Map<Item, ISubtypeRegistry.ISubtypeInterpreter> interpreters = new IdentityHashMap<Item, ISubtypeRegistry.ISubtypeInterpreter>();

    @Override
    public void useNbtForSubtypes(Item ... items) {
        for (Item item : items) {
            this.registerSubtypeInterpreter(item, AllNbt.INSTANCE);
        }
    }

    @Override
    public void registerNbtInterpreter(Item item, ISubtypeRegistry.ISubtypeInterpreter interpreter) {
        this.registerSubtypeInterpreter(item, interpreter);
    }

    @Override
    public void registerSubtypeInterpreter(Item item, ISubtypeRegistry.ISubtypeInterpreter interpreter) {
        ErrorUtil.checkNotNull(item, "item ");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        if (this.interpreters.containsKey(item)) {
            Log.get().error("An interpreter is already registered for this item: {}", (Object)item, (Object)new IllegalArgumentException());
            return;
        }
        this.interpreters.put(item, interpreter);
    }

    @Override
    @Nullable
    public String getSubtypeInfo(ItemStack itemStack) {
        ErrorUtil.checkNotEmpty(itemStack);
        Item item = itemStack.func_77973_b();
        ISubtypeRegistry.ISubtypeInterpreter subtypeInterpreter = this.interpreters.get(item);
        if (subtypeInterpreter != null) {
            return subtypeInterpreter.getSubtypeInfo(itemStack);
        }
        return null;
    }

    @Override
    public boolean hasSubtypeInterpreter(ItemStack itemStack) {
        ErrorUtil.checkNotEmpty(itemStack);
        Item item = itemStack.func_77973_b();
        return this.interpreters.containsKey(item);
    }

    private static class AllNbt
    implements ISubtypeRegistry.ISubtypeInterpreter {
        public static final AllNbt INSTANCE = new AllNbt();

        private AllNbt() {
        }

        @Override
        @Nullable
        public String getSubtypeInfo(ItemStack itemStack) {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
                return null;
            }
            return nbtTagCompound.toString();
        }
    }
}

