/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.IllegalFormatException;
import java.util.Locale;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.translation.I18n;

public final class Translator {
    private Translator() {
    }

    public static String translateToLocal(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static String translateToLocalFormatted(String key, Object ... format) {
        String s = Translator.translateToLocal(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            String errorMessage = "Format error: " + s;
            Log.error(errorMessage, e);
            return errorMessage;
        }
    }

    public static String toLowercaseWithLocale(String string) {
        return string.toLowerCase(Translator.getLocale());
    }

    private static Locale getLocale() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null) {
            return minecraft.func_135016_M().func_135041_c().getJavaLocale();
        }
        return Locale.getDefault();
    }
}

