/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting.replacers;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.StreamSupport;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStackTemplate;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class ShieldDecorationRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes() {
        Iterable banners = RegistryUtil.getRegistry(Registries.ITEM).getTagOrEmpty(ItemTags.BANNERS);
        EnumSet<DyeColor> colors = EnumSet.noneOf(DyeColor.class);
        return StreamSupport.stream(banners.spliterator(), false).filter(Holder::isBound).map(Holder::value).filter(BannerItem.class::isInstance).map(BannerItem.class::cast).filter(item -> colors.add(item.getColor())).map(ShieldDecorationRecipeMaker::createRecipe).toList();
    }

    private static RecipeHolder<CraftingRecipe> createRecipe(BannerItem banner) {
        ItemStackTemplate output = ShieldDecorationRecipeMaker.createOutput(banner);
        Identifier id = Identifier.fromNamespaceAndPath((String)"minecraft", (String)("jei.shield.decoration." + banner.getDescriptionId()));
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)id);
        ShapelessRecipe recipe = new ShapelessRecipe("jei.shield.decoration", CraftingBookCategory.MISC, output, List.of(Ingredient.of((ItemLike)Items.SHIELD), Ingredient.of((ItemLike)banner)));
        return new RecipeHolder(resourceKey, (Recipe)recipe);
    }

    private static ItemStackTemplate createOutput(BannerItem banner) {
        DyeColor color = banner.getColor();
        DataComponentPatch components = DataComponentPatch.builder().set(DataComponents.BASE_COLOR, (Object)color).build();
        return new ItemStackTemplate(Items.SHIELD, components);
    }

    private ShieldDecorationRecipeMaker() {
    }
}

