/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.library.recipes.RecipeSerializers;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;

public class JeiShapedRecipe
implements CraftingRecipe {
    private final ShapedRecipePattern pattern;
    private final List<SlotDisplay> displays;
    private final SlotDisplay results;
    private final String group;
    private final CraftingBookCategory category;

    public JeiShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, List<SlotDisplay> displays, SlotDisplay results) {
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.displays = displays;
        this.results = results;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return RecipeSerializers.getJeiShapedRecipeSerializer();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
    }

    public String group() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.displays, this.results, (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public boolean showNotification() {
        return false;
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.pattern.matches(input);
    }

    public ItemStack assemble(CraftingInput input) {
        Minecraft minecraft = Minecraft.getInstance();
        ContextMap contextmap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(minecraft.level)));
        return this.results.resolveForFirstStack(contextmap).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public static class Serializer
    implements RecipeSerializer<JeiShapedRecipe> {
        public static final MapCodec<JeiShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedRecipe -> shapedRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedRecipe -> shapedRecipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedRecipe -> shapedRecipe.pattern), (App)Codec.list((Codec)SlotDisplay.CODEC).fieldOf("display").forGetter(shapedRecipe -> shapedRecipe.displays), (App)SlotDisplay.CODEC.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.results)).apply((Applicative)instance, JeiShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, JeiShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<JeiShapedRecipe> codec() {
            return CODEC;
        }

        @Deprecated
        public StreamCodec<RegistryFriendlyByteBuf, JeiShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static JeiShapedRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String string = buffer.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedRecipePattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            int displayCount = buffer.readVarInt();
            if (displayCount < 9) {
                throw new IllegalArgumentException("Display count must be 9 or fewer");
            }
            ArrayList<SlotDisplay> displays = new ArrayList<SlotDisplay>(displayCount);
            for (int i = 0; i < displayCount; ++i) {
                SlotDisplay display = (SlotDisplay)SlotDisplay.STREAM_CODEC.decode((Object)buffer);
                displays.add(display);
            }
            SlotDisplay results = (SlotDisplay)SlotDisplay.STREAM_CODEC.decode((Object)buffer);
            return new JeiShapedRecipe(string, craftingBookCategory, shapedRecipePattern, displays, results);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, JeiShapedRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            List<SlotDisplay> displays = recipe.displays;
            buffer.writeVarInt(displays.size());
            for (SlotDisplay display : displays) {
                SlotDisplay.STREAM_CODEC.encode((Object)buffer, (Object)display);
            }
            SlotDisplay.STREAM_CODEC.encode((Object)buffer, (Object)recipe.results);
        }
    }
}

