/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class RenderHelper
implements IPlatformRenderHelper {
    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        return minecraft.font;
    }

    @Override
    public boolean shouldRender(MobEffectInstance potionEffect) {
        return true;
    }

    @Override
    public @Nullable TextureAtlasSprite getTextureAtlasSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        BlockRenderDispatcher blockRendererDispatcher = minecraft.getBlockRenderer();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.getBlockModelShaper();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.getParticleIcon(blockState);
        if (textureAtlasSprite.atlasLocation().equals((Object)MissingTextureAtlasSprite.getLocation())) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Override
    public void blitSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int uPosition, int vPosition, int x, int y, int uWidth, int vHeight) {
        guiGraphics.blitSprite(renderPipeline, sprite, textureWidth, textureHeight, uPosition, vPosition, x, y, uWidth, vHeight, -1);
    }

    @Override
    public void blitNineSlicedSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, TextureAtlasSprite sprite, GuiSpriteScaling.NineSlice scaling, int xOffset, int yOffset, int width, int height) {
        guiGraphics.blitNineSlicedSprite(renderPipeline, sprite, scaling, xOffset, yOffset, width, height, -1);
    }

    @Override
    public void blitTiledSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, TextureAtlasSprite sprite, GuiSpriteScaling.Tile scaling, int xOffset, int yOffset, int width, int height, int color) {
        guiGraphics.blitTiledSprite(renderPipeline, sprite, xOffset, yOffset, width, height, 0, 0, scaling.width(), scaling.height(), scaling.width(), scaling.height(), color);
    }

    @Override
    public Optional<NativeImage> getMainImage(TextureAtlasSprite sprite) {
        SpriteContents contents = sprite.contents();
        NativeImage[] frames = contents.byMipLevel;
        if (frames.length == 0) {
            return Optional.empty();
        }
        NativeImage frame = frames[0];
        return Optional.ofNullable(frame);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, List<Either<FormattedText, TooltipComponent>> elements, int x, int y, Font font, ItemStack stack) {
        List components = elements.stream().flatMap(e -> (Stream)e.map(text -> font.split(text, 400).stream().map(ClientTooltipComponent::create), tooltipComponent -> Stream.of(this.createClientTooltipComponent((TooltipComponent)tooltipComponent)))).collect(Collectors.toCollection(ArrayList::new));
        guiGraphics.setTooltipForNextFrameInternal(font, components, x, y, DefaultTooltipPositioner.INSTANCE, null, true);
    }

    @Override
    public Component getName(TagKey<?> tagKey) {
        return tagKey.getName();
    }

    private ClientTooltipComponent createClientTooltipComponent(TooltipComponent tooltipComponent) {
        if (tooltipComponent instanceof ClientTooltipComponent) {
            ClientTooltipComponent clientTooltipComponent = (ClientTooltipComponent)tooltipComponent;
            return clientTooltipComponent;
        }
        return ClientTooltipComponent.create((TooltipComponent)tooltipComponent);
    }
}

