/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LookupHistoryButtonController
implements IIconButtonController {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final IClientConfig clientConfig;

    public LookupHistoryButtonController(IClientConfig clientConfig) {
        Textures textures = Internal.getTextures();
        this.offIcon = textures.getHistoryButtonDisabledIcon();
        this.onIcon = textures.getHistoryButtonEnabledIcon();
        this.clientConfig = clientConfig;
    }

    @Override
    public void getTooltips(ITooltipBuilder tooltip) {
        if (this.clientConfig.isLookupHistoryEnabled()) {
            tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.disable"));
        } else {
            tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.enable"));
        }
        tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.usage").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public void updateState(IButtonState state) {
        state.setForcePressed(this.clientConfig.isLookupHistoryEnabled());
        if (this.clientConfig.isLookupHistoryEnabled()) {
            state.setIcon(this.onIcon);
        } else {
            state.setIcon(this.offIcon);
        }
    }

    @Override
    public boolean onPress(IJeiUserInput input) {
        if (!input.isSimulate()) {
            this.clientConfig.setLookupHistoryEnabled(!this.clientConfig.isLookupHistoryEnabled());
        }
        return true;
    }
}

