/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.render.FluidTankRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.display.FluidStackContentsFactory;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class FluidHelper
implements IPlatformFluidHelperInternal<FluidStack> {
    @Override
    public IIngredientTypeWithSubtypes<Fluid, FluidStack> getFluidIngredientType() {
        return NeoForgeTypes.FLUID_STACK;
    }

    @Override
    public IIngredientRenderer<FluidStack> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<FluidStack>(this, capacity, showCapacity, width, height);
    }

    @Override
    public int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    @Override
    public long getAmount(FluidStack ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public FluidStack copyWithAmount(FluidStack ingredient, long amount) {
        FluidStack copy = ingredient.copy();
        int intAmount = Math.toIntExact(amount);
        copy.setAmount(intAmount);
        return copy;
    }

    @Override
    public DataComponentPatch getComponentsPatch(FluidStack ingredient) {
        return ingredient.getComponentsPatch();
    }

    @Override
    public void getTooltip(List<Component> tooltip, FluidStack ingredient, TooltipFlag tooltipFlag) {
        Registry fluidRegistry;
        Identifier resourceLocation;
        Fluid fluid = ingredient.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return;
        }
        Component displayName = this.getDisplayName(ingredient);
        tooltip.add(displayName);
        if (tooltipFlag.isAdvanced() && (resourceLocation = (fluidRegistry = RegistryUtil.getRegistry(Registries.FLUID)).getKey((Object)fluid)) != null && resourceLocation != BuiltInRegistries.FLUID.getDefaultKey()) {
            MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)advancedId);
        }
    }

    @Override
    public long bucketVolume() {
        return 1000L;
    }

    @Override
    public Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        Identifier fluidStill = renderProperties.getStillTexture(fluidStack);
        return Optional.ofNullable(fluidStill).map(ClientHooks::getBlockMaterial).map(material -> Minecraft.getInstance().getAtlasManager().get(material)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation());
    }

    @Override
    public Component getDisplayName(FluidStack ingredient) {
        Component displayName = ingredient.getHoverName();
        Fluid fluid = ingredient.getFluid();
        if (!fluid.isSource(fluid.defaultFluidState())) {
            return Component.translatable((String)"jei.tooltip.liquid.flowing", (Object[])new Object[]{displayName});
        }
        return displayName;
    }

    @Override
    public FluidStack create(Holder<Fluid> fluid, long amount, DataComponentPatch components) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack(fluid, intAmount, components);
    }

    @Override
    public FluidStack create(Holder<Fluid> fluid, long amount) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack(fluid, intAmount);
    }

    @Override
    public FluidStack copy(FluidStack ingredient) {
        return ingredient.copy();
    }

    @Override
    public FluidStack normalize(FluidStack ingredient) {
        if (ingredient.getAmount() == 1000) {
            return ingredient;
        }
        return ingredient.copyWithAmount(1000);
    }

    @Override
    public Optional<FluidStack> getContainedFluid(ITypedIngredient<?> ingredient) {
        return ingredient.getItemStack().map(FluidUtil::getFirstStackContained).filter(i -> !i.isEmpty());
    }

    @Override
    public Codec<FluidStack> getCodec() {
        return FluidStack.fixedAmountCodec((int)1000);
    }

    @Override
    public Optional<DisplayContentsFactory<FluidStack>> getDisplayContentsFactoryForStacks() {
        return Optional.of(FluidStackContentsFactory.INSTANCE);
    }
}

