/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.Internal;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandler<T extends AbstractContainerScreen<?>>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;

    public DebugGhostIngredientHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(0, 0, 20, 20), this.ingredientManager));
        if (doStart) {
            IIngredientType<I> ingredientType = typedIngredient.getType();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("1: Ghost Ingredient Handling Starting with {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(20, 20, 20, 20), this.ingredientManager));
        }
        IScreenHelper screenHelper = Internal.getJeiRuntime().getScreenHelper();
        screenHelper.getGuiProperties(gui).ifPresent(guiProperties -> typedIngredient.getItemStack().ifPresent(itemStack -> {
            int guiLeft = guiProperties.guiLeft();
            int guiTop = guiProperties.guiTop();
            boolean even = true;
            int count = 0;
            for (Slot slot : gui.getMenu().slots) {
                if (even) {
                    Rect2i area = new Rect2i(guiLeft + slot.x, guiTop + slot.y, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area, this.ingredientManager));
                }
                if (++count > 10) break;
                even = !even;
            }
        }));
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("1: Ghost Ingredient Handling Complete");
    }

    private record DebugInfoTarget<I>(String message, Rect2i rectangle, IIngredientManager ingredientManager) implements IGhostIngredientHandler.Target<I>
    {
        @Override
        public Rect2i getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientType<I> ingredientType = this.ingredientManager.getIngredientTypeChecked(ingredient).orElseThrow();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("1: {}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

