/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

public class DisplayIngredientAcceptor
implements IIngredientAcceptor<DisplayIngredientAcceptor> {
    private final IIngredientManager ingredientManager;
    private final List<@Nullable ITypedIngredient<?>> ingredients = new ArrayList();

    public DisplayIngredientAcceptor(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public DisplayIngredientAcceptor addIngredientsUnsafe(List<?> ingredients) {
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        for (Object ingredient : ingredients) {
            ITypedIngredient<?> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredient, false);
            this.ingredients.add(typedIngredient);
        }
        return this;
    }

    public DisplayIngredientAcceptor add(SlotDisplay slotDisplay) {
        Preconditions.checkNotNull((Object)slotDisplay, (Object)"slotDisplay");
        TypedIngredient.createAndFilterInvalidList(this.ingredientManager, slotDisplay, false).forEach(this.ingredients::add);
        return this;
    }

    public <I> DisplayIngredientAcceptor add(IIngredientType<I> ingredientType, SlotDisplay slotDisplay) {
        Preconditions.checkNotNull(ingredientType, (Object)"ingredientType");
        Preconditions.checkNotNull((Object)slotDisplay, (Object)"slotDisplay");
        TypedIngredient.createAndFilterInvalidList(this.ingredientManager, ingredientType, slotDisplay, false).forEach(this.ingredients::add);
        return this;
    }

    public <T> DisplayIngredientAcceptor addIngredients(IIngredientType<T> ingredientType, List<@Nullable T> ingredients) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        List<@Nullable ITypedIngredient<T>> typedIngredients = TypedIngredient.createAndFilterInvalidList(this.ingredientManager, ingredientType, ingredients, false);
        this.ingredients.addAll(typedIngredients);
        return this;
    }

    public DisplayIngredientAcceptor add(Ingredient ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        return this.add(ingredient.display());
    }

    public <I> DisplayIngredientAcceptor add(IIngredientType<I> ingredientType, Ingredient ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        return this.add((IIngredientType)ingredientType, ingredient.display());
    }

    public <T> DisplayIngredientAcceptor add(IIngredientType<T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        this.addIngredientInternal(ingredientType, ingredient);
        return this;
    }

    public <I> DisplayIngredientAcceptor add(ITypedIngredient<I> typedIngredient) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        ITypedIngredient<I> copy = TypedIngredient.defensivelyCopyTypedIngredientFromApi(this.ingredientManager, typedIngredient);
        this.ingredients.add(copy);
        return this;
    }

    public DisplayIngredientAcceptor add(Fluid fluid) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), fluidHelper.bucketVolume(), DataComponentPatch.EMPTY);
    }

    public DisplayIngredientAcceptor add(Fluid fluid, long amount) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), amount, DataComponentPatch.EMPTY);
    }

    public DisplayIngredientAcceptor add(Fluid fluid, long amount, DataComponentPatch componentPatch) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), amount, componentPatch);
    }

    private <T> DisplayIngredientAcceptor addFluidInternal(IPlatformFluidHelperInternal<T> fluidHelper, Holder<Fluid> fluid, long amount, DataComponentPatch tag) {
        Object fluidStack = fluidHelper.create(fluid, amount, tag);
        IIngredientTypeWithSubtypes fluidIngredientType = fluidHelper.getFluidIngredientType();
        this.addIngredientInternal((IIngredientType<T>)fluidIngredientType, (T)fluidStack);
        return this;
    }

    public DisplayIngredientAcceptor addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        for (ITypedIngredient<?> typedIngredient : ingredients) {
            this.add((ITypedIngredient)typedIngredient);
        }
        return this;
    }

    public DisplayIngredientAcceptor addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        for (Optional<ITypedIngredient<?>> o : ingredients) {
            if (o.isPresent()) {
                this.add((ITypedIngredient)o.get());
                continue;
            }
            this.ingredients.add(null);
        }
        return this;
    }

    private <T> void addIngredientInternal(IIngredientType<T> ingredientType, @Nullable T ingredient) {
        ITypedIngredient<T> result = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, false);
        this.ingredients.add(result);
    }

    public @UnmodifiableView List<@Nullable ITypedIngredient<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }

    public IntSet getMatches(IFocusGroup focusGroup, RecipeIngredientRole role) {
        List focuses = focusGroup.getFocuses(role).toList();
        IntOpenHashSet results = new IntOpenHashSet();
        for (IFocus focus : focuses) {
            this.getMatches(focus, (IntSet)results);
        }
        return results;
    }

    private <T> void getMatches(IFocus<T> focus, IntSet results) {
        List<@Nullable ITypedIngredient<?>> ingredients = this.getAllIngredients();
        if (ingredients.isEmpty()) {
            return;
        }
        ITypedIngredient focusValue = focus.getTypedValue();
        IIngredientType ingredientType = focusValue.getType();
        IIngredientHelper ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        Object focusUid = ingredientHelper.getUid(focusValue, UidContext.Ingredient);
        for (int i = 0; i < ingredients.size(); ++i) {
            Object uniqueId;
            ITypedIngredient ingredient;
            ITypedIngredient<?> typedIngredient = ingredients.get(i);
            if (typedIngredient == null || (ingredient = typedIngredient.cast(ingredientType)) == null || !focusUid.equals(uniqueId = ingredientHelper.getUid(ingredient, UidContext.Ingredient))) continue;
            results.add(i);
        }
    }
}

