/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.color;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import mezz.jei.library.color.MMCQ;
import net.minecraft.util.ARGB;
import org.jspecify.annotations.Nullable;

public class ColorThief {
    public static int[][] getPalette(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return new int[0][0];
        }
        return cmap.palette();
    }

    public static @Nullable MMCQ.CMap getColorMap(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (sourceImage.format() == NativeImage.Format.RGBA) {
            int[][] pixelArray = ColorThief.getPixels(sourceImage, quality, ignoreWhite);
            return MMCQ.quantize(pixelArray, colorCount);
        }
        return null;
    }

    private static int[][] getPixels(NativeImage sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        int i = 0;
        while (i < pixelCount) {
            int x = i % width;
            int y = i / width;
            int pixel = sourceImage.getPixel(x, y);
            int a = ARGB.alpha((int)pixel);
            int b = ARGB.blue((int)pixel);
            int g = ARGB.green((int)pixel);
            int r = ARGB.red((int)pixel);
            if (!(a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250)) {
                pixelArray[numUsedPixels] = new int[]{r, g, b};
                ++numUsedPixels;
                i += quality;
                continue;
            }
            ++i;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

