/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> ingredients;
    private final List<ItemStack> potionInputs;
    private final ItemStack potionOutput;
    private final Identifier uid;
    private final BrewingRecipeUtil brewingRecipeUtil;

    public JeiBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, Identifier uid, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = List.copyOf(ingredients);
        this.potionInputs = List.copyOf(potionInputs);
        this.potionOutput = potionOutput;
        this.uid = uid;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
    }

    public List<ItemStack> getPotionInputs() {
        return this.potionInputs;
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }

    public Identifier getUid() {
        return this.uid;
    }

    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        return this.uid.equals((Object)other.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        ItemStack input = this.potionInputs.getFirst();
        String inputName = PotionSubtypeInterpreter.INSTANCE.getStringName(input);
        String outputName = PotionSubtypeInterpreter.INSTANCE.getStringName(this.potionOutput);
        return String.valueOf(this.ingredients) + " + [" + String.valueOf(input.getItem()) + " " + inputName + "] = [" + String.valueOf(this.potionOutput) + " " + outputName + "]";
    }
}

