/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.subtypes;

import java.util.IdentityHashMap;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import org.jspecify.annotations.Nullable;

public class SubtypeInterpreters {
    private final Map<Object, ISubtypeInterpreter<?>> map = new IdentityHashMap();

    public <B, I> boolean addInterpreter(IIngredientTypeWithSubtypes<B, I> type, B base, ISubtypeInterpreter<I> interpreter) {
        if (!type.getIngredientBaseClass().isInstance(base)) {
            throw new IllegalArgumentException(String.format("base must be instance of %s but got %s instead", type.getIngredientBaseClass(), base.getClass()));
        }
        if (this.map.containsKey(base)) {
            return false;
        }
        this.map.put(base, interpreter);
        return true;
    }

    public <B, I> @Nullable ISubtypeInterpreter<I> get(IIngredientTypeWithSubtypes<B, I> type, I ingredient) {
        Object base = type.getBase(ingredient);
        return this.getFromBase(type, base);
    }

    public <B, I> @Nullable ISubtypeInterpreter<I> getFromBase(IIngredientTypeWithSubtypes<B, I> type, B ingredientBase) {
        ISubtypeInterpreter<?> interpreter;
        ISubtypeInterpreter<?> cast = interpreter = this.map.get(ingredientBase);
        return cast;
    }

    public <B, T> boolean contains(IIngredientTypeWithSubtypes<B, T> type, T ingredient) {
        Object base = type.getBase(ingredient);
        return this.map.containsKey(base);
    }
}

