/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.ICraftingStationLookup;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.advanced.IRecipeButtonControllerFactory;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.RecipeLayoutDrawableErrored;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.Pair;
import mezz.jei.library.gui.ingredients.CycleTimer;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.recipes.RecipeLayout;
import mezz.jei.library.gui.recipes.layout.builder.RecipeSlotBuilder;
import mezz.jei.library.recipes.CraftingStationLookup;
import mezz.jei.library.recipes.RecipeCategoriesLookup;
import mezz.jei.library.recipes.RecipeLookup;
import mezz.jei.library.recipes.RecipeManagerInternal;
import mezz.jei.library.util.IngredientSupplierHelper;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IIngredientManager ingredientManager;
    private final ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators;
    private final List<IRecipeButtonControllerFactory> recipeButtonControllerFactories;

    public RecipeManager(RecipeManagerInternal internal, IIngredientManager ingredientManager, ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators, List<IRecipeButtonControllerFactory> recipeButtonControllerFactories) {
        this.internal = internal;
        this.ingredientManager = ingredientManager;
        this.recipeCategoryDecorators = recipeCategoryDecorators;
        this.recipeButtonControllerFactories = recipeButtonControllerFactories;
    }

    public <R> IRecipeLookup<R> createRecipeLookup(IRecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        return new RecipeLookup<R>(recipeType, this.internal, this.ingredientManager);
    }

    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new RecipeCategoriesLookup(this.internal, this.ingredientManager);
    }

    public <T> IRecipeCategory<T> getRecipeCategory(IRecipeType<T> recipeType) {
        return this.internal.getRecipeCategory(recipeType);
    }

    public IRecipeCatalystLookup createRecipeCatalystLookup(IRecipeType<?> recipeType) {
        return new CraftingStationLookup(recipeType, this.internal);
    }

    public ICraftingStationLookup createCraftingStationLookup(IRecipeType<?> recipeType) {
        return new CraftingStationLookup(recipeType, this.internal);
    }

    public <T> void addRecipes(IRecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(recipes, (String)"recipes");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(recipeType, recipes);
    }

    private <T> @Unmodifiable List<IRecipeCategoryDecorator<T>> getRecipeCategoryDecorators(IRecipeType<T> recipeType) {
        ImmutableList decorators = this.recipeCategoryDecorators.get(recipeType);
        return (List)decorators;
    }

    public <T> IRecipeLayoutDrawable<T> createRecipeLayoutDrawableOrShowError(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup) {
        int borderPadding;
        DrawableBlank recipeBackground;
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipe, (String)"recipe");
        ErrorUtil.checkNotNull((Object)focusGroup, (String)"focusGroup");
        IRecipeType recipeType = recipeCategory.getRecipeType();
        List<IRecipeCategoryDecorator<T>> decorators = this.getRecipeCategoryDecorators(recipeType);
        if (recipeCategory.needsRecipeBorder()) {
            recipeBackground = Internal.getTextures().getRecipeBackground();
            borderPadding = 4;
        } else {
            recipeBackground = DrawableBlank.EMPTY;
            borderPadding = 0;
        }
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager, (IScalableDrawable)recipeBackground, borderPadding).orElseGet(() -> RecipeManager.lambda$createRecipeLayoutDrawableOrShowError$0(recipeCategory, recipe, (IScalableDrawable)recipeBackground, borderPadding));
    }

    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup) {
        int borderPadding;
        DrawableBlank recipeBackground;
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipe, (String)"recipe");
        ErrorUtil.checkNotNull((Object)focusGroup, (String)"focusGroup");
        IRecipeType recipeType = recipeCategory.getRecipeType();
        List<IRecipeCategoryDecorator<T>> decorators = this.getRecipeCategoryDecorators(recipeType);
        if (recipeCategory.needsRecipeBorder()) {
            recipeBackground = Internal.getTextures().getRecipeBackground();
            borderPadding = 4;
        } else {
            recipeBackground = DrawableBlank.EMPTY;
            borderPadding = 0;
        }
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager, (IScalableDrawable)recipeBackground, borderPadding);
    }

    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup, IScalableDrawable background, int borderSize) {
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipe, (String)"recipe");
        ErrorUtil.checkNotNull((Object)focusGroup, (String)"focusGroup");
        ErrorUtil.checkNotNull((Object)background, (String)"background");
        IRecipeType recipeType = recipeCategory.getRecipeType();
        List<IRecipeCategoryDecorator<T>> decorators = this.getRecipeCategoryDecorators(recipeType);
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager, background, borderSize);
    }

    public IRecipeSlotDrawable createRecipeSlotDrawable(RecipeIngredientRole role, List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusedIngredients, int ingredientCycleOffset) {
        RecipeSlotBuilder builder = new RecipeSlotBuilder(this.ingredientManager, 0, role);
        builder.addOptionalTypedIngredients(ingredients);
        CycleTimer cycleTimer = CycleTimer.create(ingredientCycleOffset);
        Pair<Integer, IRecipeSlotDrawable> result = builder.build(focusedIngredients, (ICycler)cycleTimer);
        return (IRecipeSlotDrawable)result.second();
    }

    public <T> IIngredientSupplier getRecipeIngredients(IRecipeCategory<T> recipeCategory, T recipe) {
        return IngredientSupplierHelper.getIngredientSupplier(recipe, recipeCategory, this.ingredientManager);
    }

    public <T> void hideRecipes(IRecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, (String)"recipe");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.hideRecipes(recipeType, recipes);
    }

    public <T> void unhideRecipes(IRecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, (String)"recipe");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipes(recipeType, recipes);
    }

    public void hideRecipeCategory(IRecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeType);
    }

    public void unhideRecipeCategory(IRecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeType);
    }

    public <T> Optional<IRecipeType<T>> getRecipeType(Identifier recipeUid, Class<? extends T> recipeClass) {
        return this.internal.getRecipeType(recipeUid, recipeClass);
    }

    public Optional<IRecipeType<?>> getRecipeType(Identifier recipeUid) {
        return this.internal.getRecipeType(recipeUid);
    }

    public List<IRecipeButtonControllerFactory> getRecipeButtonControllerFactories() {
        return this.recipeButtonControllerFactories;
    }

    private static /* synthetic */ IRecipeLayoutDrawable lambda$createRecipeLayoutDrawableOrShowError$0(IRecipeCategory recipeCategory, Object recipe, IScalableDrawable recipeBackground, int borderPadding) {
        return new RecipeLayoutDrawableErrored(recipeCategory, recipe, recipeBackground, borderPadding);
    }
}

