/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.codecs.EnumCodec;
import mezz.jei.common.codecs.TupleCodec;
import mezz.jei.common.codecs.TypedIngredientCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import org.jspecify.annotations.Nullable;

public class CodecHelper
implements ICodecHelper {
    private static final Codec<RecipeHolder<?>> RECIPE_HOLDER_CODEC = Codec.lazyInitialized(() -> {
        RecipeMap recipes = Internal.getClientSyncedRecipes();
        return Codec.either((Codec)ResourceKey.codec((ResourceKey)Registries.RECIPE), (Codec)TupleCodec.of((Codec)ResourceKey.codec((ResourceKey)Registries.RECIPE), (Codec)Recipe.CODEC)).flatXmap(either -> (DataResult)either.map(recipeKey -> {
            RecipeHolder recipeHolder = recipes.byKey(recipeKey);
            if (recipeHolder == null) {
                return DataResult.error(() -> "Could not find recipe for key: " + String.valueOf(recipeKey));
            }
            return DataResult.success((Object)recipeHolder);
        }, pair -> {
            ResourceKey recipeKey = (ResourceKey)pair.getFirst();
            Recipe recipe = (Recipe)pair.getSecond();
            if (recipe == null) {
                return DataResult.error(() -> "Could not find recipe for key: " + String.valueOf(recipeKey));
            }
            RecipeHolder recipeHolder = new RecipeHolder(recipeKey, recipe);
            return DataResult.success((Object)recipeHolder);
        }), recipeHolder -> {
            ResourceKey recipeKey = recipeHolder.id();
            RecipeHolder found = recipes.byKey(recipeKey);
            if (recipeHolder.equals((Object)found)) {
                return DataResult.success((Object)Either.left((Object)recipeKey));
            }
            Recipe recipe = recipeHolder.value();
            return DataResult.success((Object)Either.right((Object)Pair.of((Object)recipeKey, (Object)recipe)));
        });
    });
    private final IIngredientManager ingredientManager;
    private final IFocusFactory focusFactory;
    private final Map<IRecipeType<?>, Codec<?>> defaultRecipeCodecs = new HashMap();
    private @Nullable Codec<IRecipeType<?>> recipeTypeCodec;

    public CodecHelper(IIngredientManager ingredientManager, IFocusFactory focusFactory) {
        this.ingredientManager = ingredientManager;
        this.focusFactory = focusFactory;
    }

    public Codec<IIngredientType<?>> getIngredientTypeCodec() {
        return TypedIngredientCodecs.getIngredientTypeCodec((IIngredientManager)this.ingredientManager);
    }

    public MapCodec<ITypedIngredient<?>> getTypedIngredientCodec() {
        return TypedIngredientCodecs.getIngredientCodec((IIngredientManager)this.ingredientManager);
    }

    public <T> Codec<ITypedIngredient<T>> getTypedIngredientCodec(IIngredientType<T> ingredientType) {
        return TypedIngredientCodecs.getIngredientCodec(ingredientType, (IIngredientManager)this.ingredientManager);
    }

    public <T extends RecipeHolder<?>> Codec<T> getRecipeHolderCodec() {
        Codec<RecipeHolder<?>> recipeHolderCodec = RECIPE_HOLDER_CODEC;
        return recipeHolderCodec;
    }

    public <T> Codec<T> getSlowRecipeCategoryCodec(IRecipeCategory<T> recipeCategory, IRecipeManager recipeManager) {
        IRecipeType recipeType = recipeCategory.getRecipeType();
        Object codec = this.defaultRecipeCodecs.get(recipeType);
        if (codec == null) {
            codec = this.createDefaultRecipeCategoryCodec(recipeManager, recipeCategory);
            this.defaultRecipeCodecs.put((IRecipeType<?>)recipeType, (Codec<?>)codec);
        }
        return codec;
    }

    private <T> Codec<T> createDefaultRecipeCategoryCodec(IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        Codec dataCodec = RecordCodecBuilder.create(builder -> builder.group((App)Identifier.CODEC.fieldOf("registryId").forGetter(Data::registryId), (App)this.getTypedIngredientCodec().codec().fieldOf("ingredient").forGetter(Data::ingredient), (App)EnumCodec.create(RecipeIngredientRole.class).fieldOf("ingredient_role").forGetter(Data::ingredientRole)).apply((Applicative)builder, Data::new));
        return dataCodec.flatXmap(data -> {
            Identifier registryName = data.registryId();
            ITypedIngredient<?> ingredient = data.ingredient();
            IFocus focus = this.focusFactory.createFocus(data.ingredientRole(), ingredient);
            IRecipeType recipeType = recipeCategory.getRecipeType();
            return recipeManager.createRecipeLookup(recipeType).limitFocus(List.of(focus)).get().filter(recipe -> registryName.equals((Object)recipeCategory.getIdentifier(recipe))).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No recipe found for registry id: " + String.valueOf(registryName)));
        }, recipe -> {
            Identifier registryId = recipeCategory.getIdentifier(recipe);
            if (registryId == null) {
                return DataResult.error(() -> "No registry id for recipe");
            }
            IIngredientSupplier ingredients = recipeManager.getRecipeIngredients(recipeCategory, recipe);
            List outputs = ingredients.getIngredients(RecipeIngredientRole.OUTPUT);
            if (!outputs.isEmpty()) {
                Data result = new Data(registryId, (ITypedIngredient)outputs.getFirst(), RecipeIngredientRole.OUTPUT);
                return DataResult.success((Object)result);
            }
            List inputs = ingredients.getIngredients(RecipeIngredientRole.INPUT);
            if (!inputs.isEmpty()) {
                Data result = new Data(registryId, (ITypedIngredient)inputs.getFirst(), RecipeIngredientRole.INPUT);
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "No inputs or outputs for recipe");
        });
    }

    public Codec<IRecipeType<?>> getRecipeTypeCodec(IRecipeManager recipeManager) {
        if (this.recipeTypeCodec == null) {
            this.recipeTypeCodec = Identifier.CODEC.flatXmap(uid -> recipeManager.getRecipeType(uid).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to find recipe type " + String.valueOf(uid))), recipeType -> {
                Identifier uid = recipeType.getUid();
                return DataResult.success((Object)uid);
            });
        }
        return this.recipeTypeCodec;
    }

    private record Data(Identifier registryId, ITypedIngredient<?> ingredient, RecipeIngredientRole ingredientRole) {
    }
}

