/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.gui.filter.IFilterTextSource;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.IngredientListElementFactory;
import mezz.jei.gui.ingredients.ListElementInfo;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.search.ElementPrefixParser;
import mezz.jei.gui.search.ElementSearch;
import mezz.jei.gui.search.ElementSearchLowMem;
import mezz.jei.gui.search.IElementSearch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class IngredientFilter
implements IIngredientGridSource,
IIngredientManager.IIngredientListener,
IIngredientVisibility.IListener,
IClientToggleState.IEditModeListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IClientConfig clientConfig;
    private final IFilterTextSource filterTextSource;
    private final IIngredientManager ingredientManager;
    private final Comparator<IListElement<?>> ingredientComparator;
    private final IModIdHelper modIdHelper;
    private final IIngredientVisibility ingredientVisibility;
    private final ElementPrefixParser elementPrefixParser;
    private IElementSearch elementSearch;
    private @Nullable List<IElement<?>> ingredientListCached;
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();

    public IngredientFilter(IFilterTextSource filterTextSource, IClientConfig clientConfig, IIngredientFilterConfig config, IIngredientManager ingredientManager, Comparator<IListElement<?>> ingredientComparator, List<IListElementInfo<?>> ingredients, IModIdHelper modIdHelper, IIngredientVisibility ingredientVisibility, IColorHelper colorHelper, IClientToggleState clientToggleState) {
        this.filterTextSource = filterTextSource;
        this.clientConfig = clientConfig;
        this.ingredientManager = ingredientManager;
        this.ingredientComparator = ingredientComparator;
        this.modIdHelper = modIdHelper;
        this.ingredientVisibility = ingredientVisibility;
        this.elementPrefixParser = new ElementPrefixParser(ingredientManager, config, colorHelper, modIdHelper);
        this.elementSearch = IngredientFilter.createElementSearch(clientConfig, this.elementPrefixParser);
        LOGGER.info("Adding {} ingredients", (Object)ingredients.size());
        for (IListElementInfo<?> ingredient : ingredients) {
            this.addIngredient(ingredient);
        }
        LOGGER.info("Added {} ingredients", (Object)ingredients.size());
        if (DebugConfig.isLogSuffixTreeStatsEnabled()) {
            this.elementSearch.logStatistics();
        }
        this.filterTextSource.addListener(filterText -> {
            this.invalidateCache();
            this.notifyListenersOfChange();
        });
        clientToggleState.addEditModeToggleListener((IClientToggleState.IEditModeListener)this);
    }

    private static IElementSearch createElementSearch(IClientConfig clientConfig, ElementPrefixParser elementPrefixParser) {
        if (clientConfig.isLowMemorySlowSearchEnabled()) {
            return new ElementSearchLowMem();
        }
        return new ElementSearch(elementPrefixParser);
    }

    public <V> void addIngredient(IListElementInfo<V> info) {
        IListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info, this.ingredientManager);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.ingredientListCached = null;
    }

    public void rebuildItemFilter() {
        this.invalidateCache();
        Collection<IListElement<?>> ingredients = this.elementSearch.getAllIngredients();
        this.elementSearch = IngredientFilter.createElementSearch(this.clientConfig, this.elementPrefixParser);
        List<IListElementInfo<?>> elementInfos = IngredientListElementFactory.rebuildList(this.ingredientManager, ingredients, this.modIdHelper);
        this.elementSearch.addAll(elementInfos, this.ingredientManager);
    }

    public void onEditModeChanged() {
        this.updateHidden();
    }

    public void updateHidden() {
        boolean changed = false;
        for (IListElement<?> element : this.elementSearch.getAllIngredients()) {
            changed |= this.updateHiddenState(element);
        }
        if (changed) {
            this.invalidateCache();
            this.notifyListenersOfChange();
        }
    }

    private <V> boolean updateHiddenState(IListElement<V> element) {
        ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
        boolean visible = this.ingredientVisibility.isIngredientVisible(typedIngredient);
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            return true;
        }
        return false;
    }

    public <V> void onIngredientVisibilityChanged(ITypedIngredient<V> ingredient, boolean visible) {
        IIngredientType ingredientType = ingredient.getType();
        IIngredientHelper ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        IListElement<V> match = this.elementSearch.findElement(ingredient, ingredientHelper);
        if (match != null && match.isVisible() != visible) {
            match.setVisible(visible);
            this.invalidateCache();
            this.notifyListenersOfChange();
        }
    }

    @Override
    public List<IElement<?>> getElements() {
        String filterText = this.filterTextSource.getFilterText();
        filterText = filterText.toLowerCase();
        if (this.ingredientListCached == null) {
            this.ingredientListCached = this.getIngredientListUncached(filterText).map(IngredientElement::new).toList();
        }
        return this.ingredientListCached;
    }

    public <T> List<T> getFilteredIngredients(IIngredientType<T> ingredientType) {
        return this.getElements().stream().map(IElement::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).toList();
    }

    private Stream<ITypedIngredient<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        List<SearchTokens> searchTokens = Arrays.stream(filters).map(this::parseSearchTokens).filter(s -> !s.isEmpty()).toList();
        Stream<IListElement<Object>> elementStream = searchTokens.isEmpty() ? this.elementSearch.getAllIngredients().parallelStream() : searchTokens.stream().map(this::getSearchResults).flatMap(Collection::stream).distinct();
        return elementStream.filter(IListElement::isVisible).sorted(this.ingredientComparator).map(IListElement::getTypedIngredient);
    }

    public <V> void onIngredientsAdded(IIngredientHelper<V> ingredientHelper, Collection<ITypedIngredient<V>> ingredients) {
        for (ITypedIngredient<V> value : ingredients) {
            IListElement<V> matchingElement = this.elementSearch.findElement(value, ingredientHelper);
            if (matchingElement != null) {
                this.updateHiddenState(matchingElement);
                if (!DebugConfig.isDebugModeEnabled()) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
                continue;
            }
            IListElementInfo<V> listElementInfo = ListElementInfo.create(value, this.ingredientManager, this.modIdHelper);
            if (listElementInfo == null) continue;
            this.addIngredient(listElementInfo);
            if (!DebugConfig.isDebugModeEnabled()) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
        }
        this.invalidateCache();
    }

    public <V> void onIngredientsRemoved(IIngredientHelper<V> ingredientHelper, Collection<ITypedIngredient<V>> ingredients) {
    }

    private SearchTokens parseSearchTokens(String filterText) {
        SearchTokens searchTokens = new SearchTokens(new ArrayList<ElementPrefixParser.TokenInfo>(), new ArrayList<ElementPrefixParser.TokenInfo>());
        if (filterText.isEmpty()) {
            return searchTokens;
        }
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        while (filterMatcher.find()) {
            String string = filterMatcher.group(1);
            boolean remove = string.startsWith("-");
            if (remove) {
                string = string.substring(1);
            }
            if ((string = QUOTE_PATTERN.matcher(string).replaceAll("")).isEmpty()) continue;
            this.elementPrefixParser.parseToken(string).ifPresent(result -> {
                if (remove) {
                    searchTokens.toRemove.add((ElementPrefixParser.TokenInfo)result);
                } else {
                    searchTokens.toSearch.add((ElementPrefixParser.TokenInfo)result);
                }
            });
        }
        return searchTokens;
    }

    private Set<IListElement<?>> getSearchResults(SearchTokens searchTokens) {
        List resultsPerToken = searchTokens.toSearch.stream().map(this.elementSearch::getSearchResults).toList();
        Set<IListElement<IListElement<?>>> results = IngredientFilter.intersection(resultsPerToken);
        if (results.isEmpty() && !searchTokens.toRemove.isEmpty()) {
            results.addAll(this.elementSearch.getAllIngredients());
        }
        if (!results.isEmpty() && !searchTokens.toRemove.isEmpty()) {
            for (ElementPrefixParser.TokenInfo tokenInfo : searchTokens.toRemove) {
                Set<IListElement<?>> resultsToRemove = this.elementSearch.getSearchResults(tokenInfo);
                results.removeAll(resultsToRemove);
                if (!results.isEmpty()) continue;
                break;
            }
        }
        return results;
    }

    private static <T> Set<T> intersection(List<Set<T>> sets) {
        Set<T> set;
        Set smallestSet = sets.stream().min(Comparator.comparing(Set::size)).orElseGet(Set::of);
        Set results = Collections.newSetFromMap(new IdentityHashMap());
        results.addAll(smallestSet);
        Iterator<Set<T>> iterator = sets.iterator();
        while (!(!iterator.hasNext() || (set = iterator.next()) != smallestSet && results.retainAll(set) && results.isEmpty())) {
        }
        return results;
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }

    private record SearchTokens(List<ElementPrefixParser.TokenInfo> toSearch, List<ElementPrefixParser.TokenInfo> toRemove) {
        public boolean isEmpty() {
            return this.toSearch.isEmpty() && this.toRemove.isEmpty();
        }
    }
}

