/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.input.IDragHandler;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.bookmarks.BookmarkDrag;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.IBookmarkDragTarget;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class BookmarkDragManager {
    private final BookmarkOverlay bookmarkOverlay;
    private @Nullable BookmarkDrag<?> bookmarkDrag;

    public BookmarkDragManager(BookmarkOverlay bookmarkOverlay) {
        this.bookmarkOverlay = bookmarkOverlay;
    }

    public void updateDrag(int mouseX, int mouseY) {
        if (this.bookmarkDrag != null) {
            this.bookmarkDrag.update(mouseX, mouseY);
        }
    }

    public boolean drawDraggedItem(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.bookmarkDrag != null) {
            return this.bookmarkDrag.drawItem(guiGraphics, mouseX, mouseY);
        }
        return false;
    }

    public void stopDrag() {
        if (this.bookmarkDrag != null) {
            this.bookmarkDrag.stop();
            this.bookmarkDrag = null;
        }
    }

    private <V> boolean handleClickIngredient(IDraggableIngredientInternal<V> clicked, UserInput input) {
        IElement<V> element = clicked.getElement();
        return element.getBookmark().map(bookmark -> {
            ITypedIngredient ingredient = clicked.getTypedIngredient();
            IIngredientType type = ingredient.getType();
            List<IBookmarkDragTarget> targets = this.bookmarkOverlay.createBookmarkDragTargets();
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            IIngredientRenderer ingredientRenderer = ingredientManager.getIngredientRenderer(type);
            ImmutableRect2i clickedArea = clicked.getArea();
            this.bookmarkDrag = new BookmarkDrag(this.bookmarkOverlay, targets, ingredientRenderer, ingredient, (IBookmark)bookmark, input.getMouseX(), input.getMouseY(), clickedArea);
            return true;
        }).orElse(false);
    }

    public IDragHandler createDragHandler() {
        return new DragHandler(this);
    }

    private class DragHandler
    implements IDragHandler {
        final /* synthetic */ BookmarkDragManager this$0;

        private DragHandler(BookmarkDragManager bookmarkDragManager) {
            BookmarkDragManager bookmarkDragManager2 = bookmarkDragManager;
            Objects.requireNonNull(bookmarkDragManager2);
            this.this$0 = bookmarkDragManager2;
        }

        @Override
        public Optional<IDragHandler> handleDragStart(Screen screen, UserInput input) {
            IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
            if (!clientConfig.isDragToRearrangeBookmarksEnabled()) {
                this.this$0.stopDrag();
                return Optional.empty();
            }
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player == null) {
                return Optional.empty();
            }
            return this.this$0.bookmarkOverlay.getDraggableIngredientUnderMouse(input.getMouseX(), input.getMouseY()).findFirst().flatMap(clicked -> {
                ItemStack mouseItem = player.containerMenu.getCarried();
                if (mouseItem.isEmpty() && this.this$0.handleClickIngredient(clicked, input)) {
                    return Optional.of(this);
                }
                return Optional.empty();
            });
        }

        @Override
        public boolean handleDragComplete(Screen screen, UserInput input) {
            if (this.this$0.bookmarkDrag == null) {
                return false;
            }
            boolean success = this.this$0.bookmarkDrag.onClick(input);
            this.this$0.bookmarkDrag = null;
            return success;
        }

        @Override
        public void handleDragCanceled() {
            this.this$0.stopDrag();
        }
    }
}

