/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformConfigHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHelper
implements IPlatformConfigHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public Path getModConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Optional<Screen> getConfigScreen() {
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.isModLoaded("configured")) {
            return loader.getModContainer("jei").flatMap(ConfigHelper::getConfiguredConfigScreen);
        }
        return Optional.empty();
    }

    private static Optional<Screen> getConfiguredConfigScreen(ModContainer jeiModContainer) {
        try {
            Class<?> configFactoryClass = Class.forName("com.mrcrayfish.configured.integration.CatalogueConfigFactory");
            Method createConfigScreen = configFactoryClass.getDeclaredMethod("createConfigScreen", Screen.class, ModContainer.class);
            Object screen = createConfigScreen.invoke(configFactoryClass, null, jeiModContainer);
            if (screen instanceof Screen) {
                Screen configScreen = (Screen)screen;
                return Optional.of(configScreen);
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Failed to load config screen with error:", (Throwable)e);
            return Optional.empty();
        }
    }
}

