/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.widgets;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.elements.DrawableWrappedText;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.gui.widgets.AbstractScrollWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix3x2fStack;

public class ScrollBoxRecipeWidget
extends AbstractScrollWidget
implements IScrollBoxWidget,
IJeiInputHandler {
    private IDrawable contents = DrawableBlank.EMPTY;

    public ScrollBoxRecipeWidget(int width, int height, int xPos, int yPos) {
        super(new ImmutableRect2i(xPos, yPos, width, height));
    }

    @Override
    public int getContentAreaWidth() {
        return this.contentsArea.width();
    }

    @Override
    public int getContentAreaHeight() {
        return this.contentsArea.height();
    }

    @Override
    public IScrollBoxWidget setContents(IDrawable contents) {
        this.contents = contents;
        return this;
    }

    @Override
    public IScrollBoxWidget setContents(List<FormattedText> text) {
        this.contents = new DrawableWrappedText(text, this.getContentAreaWidth());
        return this;
    }

    @Override
    protected int getVisibleAmount() {
        return this.contentsArea.height();
    }

    @Override
    protected int getHiddenAmount() {
        return Math.max(this.contents.getHeight() - this.contentsArea.height(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawContents(GuiGraphics guiGraphics, double mouseX, double mouseY, float scrollOffsetY) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        guiGraphics.enableScissor(this.contentsArea.x(), this.contentsArea.y(), this.contentsArea.width(), this.contentsArea.height());
        poseStack.pushMatrix();
        float scrollAmount = (float)this.getHiddenAmount() * scrollOffsetY;
        poseStack.translate(0.0f, -scrollAmount);
        try {
            this.contents.draw(guiGraphics);
        }
        finally {
            poseStack.popMatrix();
            guiGraphics.disableScissor();
        }
    }

    @Override
    protected float calculateScrollAmount(double scrollDeltaY) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        int smoothScrollRate = clientConfig.getSmoothScrollRate();
        int totalHeight = this.contents.getHeight();
        double scrollAmount = scrollDeltaY * (double)smoothScrollRate;
        return (float)(scrollAmount / (double)totalHeight);
    }
}

