/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.mixin;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.input.CharacterEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyboardHandler.class})
public class KeyboardHandlerMixin {
    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeCharTypedEvent(long windowHandle, CharacterEvent event, CallbackInfo ci) {
        KeyboardHandlerMixin.beforeCharTypedEventInternal(windowHandle, event, ci);
    }

    @Inject(method={"charTyped"}, at={@At(value="TAIL")}, cancellable=true)
    private void afterCharTypedEvent(long windowHandle, CharacterEvent event, CallbackInfo ci) {
        KeyboardHandlerMixin.afterCharTypedEventInternal(windowHandle, event, ci);
    }

    @Unique
    private static void beforeCharTypedEventInternal(long windowHandle, CharacterEvent event, CallbackInfo ci) {
        if (ci.isCancelled()) {
            return;
        }
        if (((JeiCharTypedEvents.BeforeCharTyped)JeiCharTypedEvents.BEFORE_CHAR_TYPED.invoker()).beforeCharTyped(windowHandle, event)) {
            ci.cancel();
        }
    }

    @Unique
    private static void afterCharTypedEventInternal(long windowHandle, CharacterEvent event, CallbackInfo ci) {
        if (ci.isCancelled()) {
            return;
        }
        if (((JeiCharTypedEvents.AfterCharTyped)JeiCharTypedEvents.AFTER_CHAR_TYPED.invoker()).afterCharTyped(windowHandle, event)) {
            ci.cancel();
        }
    }
}

