/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.FullTypedItemStack;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class TypedItemStack
implements ITypedIngredient<ItemStack> {
    private static final LoadingCache<TypedItemStack, ItemStack> CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(1L)).concurrencyLevel(1).build((CacheLoader)new CacheLoader<TypedItemStack, ItemStack>(){

        public ItemStack load(TypedItemStack key) {
            return key.createItemStackUncached();
        }
    });

    public static ITypedIngredient<ItemStack> create(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return NormalizedTypedItemStack.create((Holder<Item>)ingredient.getItemHolder(), ingredient.getComponentsPatch());
        }
        return new FullTypedItemStack((Holder<Item>)ingredient.getItemHolder(), ingredient.getComponentsPatch(), ingredient.getCount());
    }

    public static ITypedIngredient<ItemStack> normalize(ITypedIngredient<ItemStack> typedIngredient) {
        if (typedIngredient instanceof TypedItemStack) {
            TypedItemStack typedItemStack = (TypedItemStack)typedIngredient;
            return typedItemStack.getNormalized();
        }
        ItemStack itemStack = (ItemStack)typedIngredient.getIngredient();
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getComponentsPatch());
    }

    public final ItemStack getIngredient() {
        return (ItemStack)CACHE.getUnchecked((Object)this);
    }

    public final Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    public final <B> B getBaseIngredient(IIngredientTypeWithSubtypes<B, ItemStack> ingredientType) {
        Item item = this.getItem();
        Class ingredientBaseClass = ingredientType.getIngredientBaseClass();
        return (B)ingredientBaseClass.cast(item);
    }

    public final IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    protected abstract Item getItem();

    protected abstract TypedItemStack getNormalized();

    protected abstract ItemStack createItemStackUncached();
}

