package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.KeyNameUtil;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_3675;

public class MouseUserInput extends UserInput {
	private final class_11909 event;
	private final boolean doubleClick;
	private final class_3675.class_306 key;
	private final InputType inputType;

	public MouseUserInput(class_11909 event, boolean doubleClick, InputType inputType) {
		this.event = event;
		this.doubleClick = doubleClick;
		this.inputType = inputType;
		this.key = class_3675.class_307.field_1672.method_1447(event.method_74228());
	}

	@Override
	public class_3675.class_306 getKey() {
		return key;
	}

	@Override
	public double getMouseX() {
		return event.comp_4798();
	}

	@Override
	public double getMouseY() {
		return event.comp_4799();
	}

	@Override
	public InputType getInputType() {
		return inputType;
	}

	@Override
	public int getModifiers() {
		return event.comp_4797();
	}

	@Override
	public boolean isSimulate() {
		return inputType == InputType.SIMULATE;
	}

	@Override
	public boolean isAllowedChatCharacter() {
		return false;
	}

	@Override
	public Either<class_11909, class_11908> getEvent() {
		return Either.left(event);
	}

	@Override
	public boolean ifMouseEvent(MouseClickable mouseClickable) {
		return mouseClickable.mouseClicked(event, doubleClick);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
			.add("inputType", inputType)
			.add("key", KeyNameUtil.getKeyDisplayName(key).getString())
			.add("event", event)
			.toString();
	}
}
