/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;

public class ErrorIngredientRenderer
implements IIngredientRenderer<ErrorIngredient> {
    private final IIngredientHelper<ErrorIngredient> ingredientHelper;

    public ErrorIngredientRenderer(IIngredientHelper<ErrorIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    public void render(GuiGraphics guiGraphics, ErrorIngredient ingredient) {
        Minecraft minecraft = Minecraft.getInstance();
        if (ingredient.crashType() == ErrorIngredient.CrashType.TooltipCrash) {
            Font font = this.getFontRenderer(minecraft, ingredient);
            guiGraphics.drawString(font, "JEI", 0, 0, -65536, false);
            guiGraphics.drawString(font, "TEST", 0, 8, -65536, false);
        }
    }

    public List<Component> getTooltip(ErrorIngredient ingredient, TooltipFlag tooltipFlag) {
        if (ingredient.crashType() == ErrorIngredient.CrashType.TooltipCrash) {
            throw new RuntimeException("intentional tooltip crash for testing");
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String displayName = this.ingredientHelper.getDisplayName((Object)ingredient);
        tooltip.add((Component)Component.literal((String)displayName));
        MutableComponent debugIngredient = Component.literal((String)"error ingredient");
        tooltip.add((Component)debugIngredient.withStyle(ChatFormatting.GRAY));
        return tooltip;
    }
}

