/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.jei.info.IngredientInfoRecipe;
import mezz.jei.library.recipes.RecipeManagerInternal;
import net.minecraft.network.chat.Component;

public class RecipeRegistration
implements IRecipeRegistration {
    private final IJeiHelpers jeiHelpers;
    private final IIngredientManager ingredientManager;
    private final RecipeManagerInternal recipeManager;

    public RecipeRegistration(IJeiHelpers jeiHelpers, IIngredientManager ingredientManager, RecipeManagerInternal recipeManager) {
        this.jeiHelpers = jeiHelpers;
        this.ingredientManager = ingredientManager;
        this.recipeManager = recipeManager;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return this.jeiHelpers.getVanillaRecipeFactory();
    }

    public <T> void addRecipes(IRecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(recipes, (String)"recipes");
        this.recipeManager.addRecipes(recipeType, recipes);
    }

    public <T> void addIngredientInfo(T ingredient, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotEmpty((Object[])descriptionComponents, (String)"descriptionComponents");
        this.addIngredientInfo(List.of(ingredient), ingredientType, descriptionComponents);
    }

    public <T> void addIngredientInfo(List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotEmpty((Object[])descriptionComponents, (String)"descriptionComponents");
        IJeiIngredientInfoRecipe recipe = IngredientInfoRecipe.create(this.ingredientManager, ingredients, ingredientType, descriptionComponents);
        this.addRecipes(RecipeTypes.INFORMATION, List.of(recipe));
    }
}

