/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LookupHistoryButton
extends GuiIconToggleButton {
    private final IClientConfig clientConfig;

    public static LookupHistoryButton create(IClientConfig clientConfig) {
        Textures textures = Internal.getTextures();
        IDrawableStatic offIcon = textures.getHistoryButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getHistoryButtonEnabledICon();
        return new LookupHistoryButton((IDrawable)offIcon, (IDrawable)onIcon, clientConfig);
    }

    private LookupHistoryButton(IDrawable offIcon, IDrawable onIcon, IClientConfig clientConfig) {
        super(offIcon, onIcon);
        this.clientConfig = clientConfig;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.clientConfig.isLookupHistoryEnabled()) {
            tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.disable"));
        } else {
            tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.enable"));
        }
        tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.lookupHistory.usage").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.clientConfig.isLookupHistoryEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            this.clientConfig.setLookupHistoryEnabled(!this.clientConfig.isLookupHistoryEnabled());
        }
        return true;
    }
}

