/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.mixin;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import net.minecraft.class_309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_309.class})
public class KeyboardHandlerMixin {
    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeCharTypedEvent(long windowPointer, int codePoint, int modifiers, CallbackInfo ci) {
        KeyboardHandlerMixin.beforeCharTypedEventInternal(windowPointer, (char)codePoint, modifiers, ci);
    }

    @Inject(method={"charTyped"}, at={@At(value="TAIL")}, cancellable=true)
    private void afterCharTypedEvent(long windowPointer, int codePoint, int modifiers, CallbackInfo ci) {
        KeyboardHandlerMixin.afterCharTypedEventInternal(windowPointer, (char)codePoint, modifiers, ci);
    }

    private static void beforeCharTypedEventInternal(long windowPointer, char codePoint, int modifiers, CallbackInfo ci) {
        if (ci.isCancelled()) {
            return;
        }
        if (((JeiCharTypedEvents.BeforeCharTyped)JeiCharTypedEvents.BEFORE_CHAR_TYPED.invoker()).beforeCharTyped(windowPointer, codePoint, modifiers)) {
            ci.cancel();
        }
    }

    private static void afterCharTypedEventInternal(long windowPointer, char codePoint, int modifiers, CallbackInfo ci) {
        if (ci.isCancelled()) {
            return;
        }
        if (((JeiCharTypedEvents.AfterCharTyped)JeiCharTypedEvents.AFTER_CHAR_TYPED.invoker()).afterCharTyped(windowPointer, codePoint, modifiers)) {
            ci.cancel();
        }
    }
}

