/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DebugIngredientHelper
implements IIngredientHelper<DebugIngredient> {
    public IIngredientType<DebugIngredient> getIngredientType() {
        return DebugIngredient.TYPE;
    }

    public String getDisplayName(DebugIngredient ingredient) {
        return "JEI Debug Item #" + ingredient.number();
    }

    public Object getUid(DebugIngredient ingredient, UidContext context) {
        return ingredient.number();
    }

    public Object getGroupingUid(DebugIngredient ingredient) {
        return DebugIngredient.class;
    }

    public ResourceLocation getResourceLocation(DebugIngredient ingredient) {
        return ResourceLocation.fromNamespaceAndPath((String)"jei", (String)("debug_" + ingredient.number()));
    }

    public DebugIngredient copyIngredient(DebugIngredient ingredient) {
        return ingredient.copy();
    }

    public String getErrorInfo(@Nullable DebugIngredient ingredient) {
        if (ingredient == null) {
            return "debug ingredient: null";
        }
        return this.getDisplayName(ingredient);
    }
}

