/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.ScalableDrawable;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.UserInputRouter;
import mezz.jei.gui.recipes.CraftingStations;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryTitle;
import mezz.jei.gui.recipes.RecipeGuiLayouts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeOptionButtons;
import mezz.jei.gui.recipes.lookups.StaticFocusedRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends Screen
implements IRecipesGui,
IRecipeFocusSource {
    private static final int borderPadding = 6;
    private static final int minRecipePadding = 4;
    private static final int navBarPadding = 2;
    private static final int titleInnerPadding = 14;
    private static final int smallButtonWidth = 13;
    private static final int smallButtonHeight = 13;
    private static final int minGuiWidth = 198;
    private final IInternalKeyMappings keyBindings;
    private final BookmarkList bookmarks;
    private final IFocusFactory focusFactory;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final RecipeGuiLayouts layouts;
    private String pageString = "1/1";
    private final ScalableDrawable background;
    private final CraftingStations craftingStations;
    private final RecipeGuiTabs recipeGuiTabs;
    private final RecipeOptionButtons optionButtons;
    private final UserInputRouter inputHandler;
    private final GuiIconButton nextRecipeCategory;
    private final GuiIconButton previousRecipeCategory;
    private final GuiIconButton nextPage;
    private final GuiIconButton previousPage;
    @Nullable
    private Screen parentScreen;
    private ImmutableRect2i idealArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private RecipeCategoryTitle recipeCategoryTitle = new RecipeCategoryTitle();
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IInternalKeyMappings keyBindings, IFocusFactory focusFactory, BookmarkList bookmarks, IGuiHelper guiHelper) {
        super((Component)Component.literal((String)"Recipes"));
        this.bookmarks = bookmarks;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this::updateLayout, focusFactory);
        this.craftingStations = new CraftingStations(recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, recipeManager, guiHelper);
        this.optionButtons = new RecipeOptionButtons(this.logic::goToFirstPage);
        this.focusFactory = focusFactory;
        this.minecraft = Minecraft.getInstance();
        this.layouts = new RecipeGuiLayouts();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButton(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButton(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButton(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButton(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getRecipeGuiBackground();
        this.inputHandler = new UserInputRouter("RecipesGui", this.layouts.createInputHandler(), new UserInputHandler(this), this.optionButtons.createInputHandler(), this.recipeGuiTabs.createInputHandler(), this.nextRecipeCategory.createInputHandler(), this.previousRecipeCategory.createInputHandler(), this.nextPage.createInputHandler(), this.previousPage.createInputHandler());
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getLeftSideExtraWidth() {
        if (this.craftingStations.isEmpty()) {
            return this.optionButtons.getWidth();
        }
        return Math.max(this.craftingStations.getWidth(), this.optionButtons.getWidth());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        int xSize = 198;
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        int ySize = clientConfig.isCenterSearchBarEnabled() ? this.height - 76 : this.height - 58;
        int extraSpace = 0;
        int maxHeight = clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.width - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = this.idealArea = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.font);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.setX(rightButtonX);
        this.nextRecipeCategory.setY(recipeClassButtonTop);
        this.previousRecipeCategory.setX(leftButtonX);
        this.previousRecipeCategory.setY(recipeClassButtonTop);
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.setX(rightButtonX);
        this.nextPage.setY(pageButtonTop);
        this.previousPage.setX(leftButtonX);
        this.previousPage.setY(pageButtonTop);
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.init = true;
        this.updateLayout();
    }

    protected void renderMenuBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        if (this.minecraft == null) {
            return;
        }
        this.renderTransparentBackground(guiGraphics);
        this.background.draw(guiGraphics, this.area);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        guiGraphics.fill(this.previousRecipeCategory.getX() + this.previousRecipeCategory.getWidth(), this.previousRecipeCategory.getY(), this.nextRecipeCategory.getX(), this.nextRecipeCategory.getY() + this.nextRecipeCategory.getHeight(), 0x30000000);
        guiGraphics.fill(this.previousPage.getX() + this.previousPage.getWidth(), this.previousPage.getY(), this.nextPage.getX(), this.nextPage.getY() + this.nextPage.getHeight(), 0x30000000);
        this.recipeCategoryTitle.draw(guiGraphics, this.font);
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.previousPage.getArea(), (ImmutableRect2i)this.nextPage.getArea());
        StringUtil.drawCenteredStringWithShadow((GuiGraphics)guiGraphics, (Font)this.font, (String)this.pageString, (ImmutableRect2i)pageArea);
        this.nextRecipeCategory.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.nextPage.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousPage.render(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.layouts.draw(guiGraphics, mouseX, mouseY);
        this.optionButtons.draw(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.craftingStations.draw(guiGraphics, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.minecraft, guiGraphics, mouseX, mouseY, partialTicks);
        this.layouts.drawTooltips(guiGraphics, mouseX, mouseY);
        this.optionButtons.drawTooltips(guiGraphics, mouseX, mouseY);
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(guiGraphics, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(guiGraphics));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawTooltip(guiGraphics, mouseX, mouseY));
        if (this.recipeCategoryTitle.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.recipeCategoryTitle.getTooltip(tooltip);
            if (!this.logic.hasAllCategories()) {
                tooltip.addKeyUsageComponent("jei.tooltip.show.all.recipes.hotkey", this.keyBindings.getLeftClick());
            }
            tooltip.draw(guiGraphics, mouseX, mouseY);
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            guiGraphics.fill(this.idealArea.getX(), this.idealArea.getY(), this.idealArea.getX() + this.idealArea.getWidth(), this.idealArea.getY() + this.idealArea.getHeight(), 0x4400FF00);
            guiGraphics.fill(this.area.getX(), this.area.getY(), this.area.getX() + this.area.getWidth(), this.area.getY() + this.area.getHeight(), 0x44990044);
            ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
            guiGraphics.fill(recipeLayoutsArea.getX(), recipeLayoutsArea.getY(), recipeLayoutsArea.getX() + recipeLayoutsArea.getWidth(), recipeLayoutsArea.getY() + recipeLayoutsArea.getHeight(), 0x44228844);
        }
    }

    private static ImmutableRect2i calculateAreaToFitLayouts(ImmutableRect2i idealArea, int screenWidth, int recipeWidth) {
        if (recipeWidth == 0) {
            return idealArea;
        }
        int padding = 12;
        int width = 186;
        width = Math.max(recipeWidth, width);
        int newWidth = width + 12;
        int newX = (screenWidth - newWidth) / 2;
        return new ImmutableRect2i(newX, idealArea.getY(), newWidth, idealArea.getHeight());
    }

    public void tick() {
        super.tick();
        AbstractContainerMenu container = this.getParentContainerMenu();
        this.layouts.tick(container);
        this.optionButtons.tick();
        this.logic.tick(container);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.minecraft != null && this.minecraft.screen == this) {
            return this.area.contains(mouseX, mouseY) || this.optionButtons.getArea().contains(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.craftingStations.getIngredientUnderMouse(mouseX, mouseY), this.layouts.getIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    @Override
    public Stream<IDraggableIngredientInternal<?>> getDraggableIngredientUnderMouse(double mouseX, double mouseY) {
        return Stream.empty();
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.layouts.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(mouseButton);
        return this.layouts.mouseDragged(mouseX, mouseY, input, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.SIMULATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.EXECUTE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IGuiProperties guiProperties = this.getProperties();
        if (guiProperties == null) {
            return false;
        }
        return this.inputHandler.handleUserInput(this, guiProperties, input, this.keyBindings);
    }

    public boolean isOpen() {
        return this.minecraft != null && this.minecraft.screen == this;
    }

    private void open() {
        if (this.minecraft != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.minecraft.screen;
            }
            this.minecraft.setScreen((Screen)this);
        }
    }

    public void onClose() {
        if (this.isOpen() && this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.onClose();
    }

    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.showFocus(checkedFocuses)) {
            this.open();
        }
    }

    public void showTypes(List<IRecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, (String)"recipeTypes");
        if (this.logic.showCategories(recipeTypes)) {
            this.open();
        }
    }

    public <T> void showRecipes(IRecipeCategory<T> recipeCategory, List<T> recipes, List<IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotEmpty(recipes, (String)"recipes");
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        StaticFocusedRecipes<T> focusedRecipes = new StaticFocusedRecipes<T>(recipeCategory, recipes);
        if (this.logic.showRecipes(focusedRecipes, checkedFocuses)) {
            this.open();
        }
    }

    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        ImmutableRect2i titleArea = MathUtil.union((ImmutableRect2i)this.previousRecipeCategory.getArea(), (ImmutableRect2i)this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.getWidth() + 14).cropRight(this.nextRecipeCategory.getWidth() + 14);
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        this.recipeCategoryTitle = RecipeCategoryTitle.create(recipeCategory, this.font, titleArea);
        ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
        int availableHeight = recipeLayoutsArea.getHeight();
        AbstractContainerMenu containerMenu = this.getParentContainerMenu();
        List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = this.logic.getVisibleRecipeLayoutsWithButtons(availableHeight, 4, containerMenu, this.bookmarks, this);
        int recipesPerPage = this.logic.getRecipesPerPage();
        this.layouts.setRecipeLayoutsWithButtons(recipeLayoutsWithButtons);
        this.layouts.tick(containerMenu);
        this.area = RecipesGui.calculateAreaToFitLayouts(this.idealArea, this.width, this.layouts.getWidth());
        recipeLayoutsArea = this.getRecipeLayoutsArea();
        this.layouts.updateLayout(recipeLayoutsArea, recipesPerPage);
        this.nextPage.active = this.previousPage.active = this.logic.hasMultiplePages();
        this.nextRecipeCategory.active = this.previousRecipeCategory.active = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        this.optionButtons.updateLayout(this.area);
        ImmutableRect2i optionButtonsArea = this.optionButtons.getArea();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.craftingStations.updateLayout(recipeCatalystIngredients, this.area, optionButtonsArea);
        this.recipeGuiTabs.initLayout(this.idealArea);
    }

    private ImmutableRect2i getRecipeLayoutsArea() {
        return new ImmutableRect2i(this.area.getX() + 6, this.area.getY() + this.headerHeight + 2, this.area.getWidth() - 12, this.area.getHeight() - (this.headerHeight + 6 + 2));
    }

    @Nullable
    public AbstractContainerMenu getParentContainerMenu() {
        Screen screen = this.parentScreen == null ? Minecraft.getInstance().screen : this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            return containerScreen.getMenu();
        }
        return null;
    }

    public Optional<Screen> getParentScreen() {
        return Optional.ofNullable(this.parentScreen);
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        int extraWidth = this.getLeftSideExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.width, this.height);
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final RecipesGui recipesGui;

        public UserInputHandler(RecipesGui recipesGui) {
            this.recipesGui = recipesGui;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipesGui.isMouseOver(mouseX, mouseY = input.getMouseY()) && this.recipesGui.recipeCategoryTitle.isMouseOver(mouseX, mouseY) && input.is(keyBindings.getLeftClick()) && (input.isSimulate() || this.recipesGui.logic.showAllRecipes())) {
                return Optional.of(this);
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (input.is(keyBindings.getCloseRecipeGui()) || input.is(minecraft.options.keyInventory)) {
                if (!input.isSimulate()) {
                    this.recipesGui.onClose();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getRecipeBack())) {
                if (!input.isSimulate()) {
                    this.recipesGui.back();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextCategory())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.nextRecipeCategory();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousCategory())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.previousRecipeCategory();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextRecipePage())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.nextPage();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousRecipePage())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.previousPage();
                }
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
            if (this.recipesGui.isMouseOver(mouseX, mouseY)) {
                if (scrollDeltaY < 0.0) {
                    this.recipesGui.logic.nextPage();
                    return Optional.of(this);
                }
                if (scrollDeltaY > 0.0) {
                    this.recipesGui.logic.previousPage();
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }
    }
}

