package mezz.jei.library.plugins.debug;

import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.Internal;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class DebugGhostIngredientHandlerTwo<T extends class_465<?>> implements IGhostIngredientHandler<T> {
	private static final Logger LOGGER = LogManager.getLogger();

	private final IIngredientManager ingredientManager;

	public DebugGhostIngredientHandlerTwo(IIngredientManager ingredientManager) {
		this.ingredientManager = ingredientManager;
	}

	@Override
	public <I> List<Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
		List<Target<I>> targets = new ArrayList<>();
		targets.add(new DebugInfoTarget<>("Got an Ingredient", new class_768(40, 40, 20, 20), ingredientManager));
		if (doStart) {
			IIngredientType<I> ingredientType = typedIngredient.getType();
			IIngredientHelper<I> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
			LOGGER.info("2: Ghost Ingredient Handler Two Starting with {}", ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
			targets.add(new DebugInfoTarget<>("Got an Ingredient", new class_768(30, 30, 20, 20), ingredientManager));
		}
		IScreenHelper screenHelper = Internal.getJeiRuntime().getScreenHelper();
		screenHelper.getGuiProperties(gui)
			.ifPresent(guiProperties -> {
				typedIngredient.getItemStack()
					.ifPresent(itemStack -> {
						final int guiLeft = guiProperties.guiLeft();
						final int guiTop = guiProperties.guiTop();
						boolean odd = false;
						int count = 0;
						for (class_1735 slot : gui.method_17577().field_7761) {
							if (odd && count > 10) {
								class_768 area = new class_768(guiLeft + slot.field_7873, guiTop + slot.field_7872, 16, 16);
								targets.add(new DebugInfoTarget<>("Got an Ingredient in Gui", area, ingredientManager));
							}
							count++;
							odd = !odd;
						}
					});
			});
		return targets;
	}

	@Override
	public void onComplete() {
		LOGGER.info("2: Ghost Ingredient Handling Complete");
	}

	private record DebugInfoTarget<I>(
		String message,
		class_768 rectangle,
		IIngredientManager ingredientManager
	) implements Target<I> {

		@Override
		public class_768 getArea() {
			return rectangle;
		}

		@Override
		public void accept(I ingredient) {
			IIngredientType<I> ingredientType = ingredientManager.getIngredientTypeChecked(ingredient)
				.orElseThrow();
			IIngredientHelper<I> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
			LOGGER.info("2: {}: {}", message, ingredientHelper.getErrorInfo(ingredient));
		}
	}
}
