package mezz.jei.fabric;

import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.JeiGuiSpriteManager;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.MinecraftLocaleSupplier;
import mezz.jei.common.util.Translator;
import mezz.jei.fabric.events.JeiIdentifiableResourceReloadListener;
import mezz.jei.fabric.events.JeiLifecycleEvents;
import mezz.jei.fabric.plugins.fabric.FabricGuiPlugin;
import mezz.jei.fabric.startup.ClientLifecycleHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_3264;
import net.minecraft.class_4013;

@SuppressWarnings("unused")
public class JustEnoughItemsClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		Translator.setLocaleSupplier(new MinecraftLocaleSupplier());
		ClientLifecycleHandler clientLifecycleHandler = new ClientLifecycleHandler();

		JeiLifecycleEvents.REGISTER_RESOURCE_RELOAD_LISTENER.register((resourceManager, textureManager) -> {
			Textures textures = Internal.getTextures();
			JeiGuiSpriteManager guiSpriteManager = textures.getGuiSpriteManager();
			resourceManager.method_14477(new JeiIdentifiableResourceReloadListener("gui_sprite_manager", guiSpriteManager));

			ClientLifecycleEvents.CLIENT_STARTED.register(event -> {
				clientLifecycleHandler.registerEvents();

				ResourceManagerHelper.get(class_3264.field_14190)
						.registerReloadListener(new JeiIdentifiableResourceReloadListener("lifecycle", clientLifecycleHandler.getReloadListener()));

				ResourceManagerHelper.get(class_3264.field_14188)
					.registerReloadListener(new JeiIdentifiableResourceReloadListener("resources_reload", createReloadListener()));
			});
		});
	}

	public class_4013 createReloadListener() {
		return (resourceManager) -> {
			FabricGuiPlugin.getResourceReloadHandler()
				.ifPresent(r -> r.method_14491(resourceManager));
		};
	}
}
