/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.google.common.base.Preconditions;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix3x2fStack;

public class HighResolutionDrawable
implements IDrawable {
    private final IDrawable drawable;
    private final int scale;

    public HighResolutionDrawable(IDrawable drawable, int scale) {
        int width = drawable.getWidth();
        int height = drawable.getHeight();
        Preconditions.checkArgument((width % scale == 0 ? 1 : 0) != 0, (Object)String.format("drawable width %s must be divisible by the scale %s", width, scale));
        Preconditions.checkArgument((height % scale == 0 ? 1 : 0) != 0, (Object)String.format("drawable height %s must be divisible by the scale %s", height, scale));
        this.drawable = drawable;
        this.scale = scale;
    }

    public int getWidth() {
        return this.drawable.getWidth() / this.scale;
    }

    public int getHeight() {
        return this.drawable.getHeight() / this.scale;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)xOffset, (float)yOffset);
        poseStack.scale(1.0f / (float)this.scale, 1.0f / (float)this.scale);
        this.drawable.draw(guiGraphics);
        poseStack.popMatrix();
    }

    public void draw(GuiGraphics guiGraphics) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.scale(1.0f / (float)this.scale, 1.0f / (float)this.scale);
        this.drawable.draw(guiGraphics);
        poseStack.popMatrix();
    }
}

