package mezz.jei.api.constants;

import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

/**
 * Built-in {@link IIngredientType} for vanilla Minecraft.
 */
public final class VanillaTypes {
	/**
	 * @since 9.7.0
	 */
	public static final IIngredientTypeWithSubtypes<class_1792, class_1799> ITEM_STACK = new IIngredientTypeWithSubtypes<>() {
		@Override
		public String getUid() {
			return "item_stack";
		}

		@Override
		public Class<? extends class_1799> getIngredientClass() {
			return class_1799.class;
		}

		@Override
		public Class<? extends class_1792> getIngredientBaseClass() {
			return class_1792.class;
		}

		@Override
		public class_1792 getBase(class_1799 ingredient) {
			return ingredient.method_7909();
		}

		@Override
		public class_1799 getDefaultIngredient(class_1792 base) {
			return base.method_7854();
		}
	};

	private VanillaTypes() {

	}
}
